/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.helpers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.swt.widgets.Control;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class LockHelper {
    private static LockHelper _instance;
    private Map<Control, Boolean> _controlStatus;
    private Map<Control, ControlDecoration> _decorationRegistry;

    private LockHelper() {
    }

    public static LockHelper getInstance() {
        if (_instance == null) {
            _instance = new LockHelper();
        }
        return _instance;
    }

    private Map<Control, Boolean> getControlStatus() {
        if (this._controlStatus == null) {
            this._controlStatus = new HashMap<Control, Boolean>();
        }
        return this._controlStatus;
    }

    private Map<Control, ControlDecoration> getDecorationRegistry() {
        if (this._decorationRegistry == null) {
            this._decorationRegistry = new HashMap<Control, ControlDecoration>();
        }
        return this._decorationRegistry;
    }

    public void decorate(Control control) {
        ControlDecoration decoration = new ControlDecoration(control, 16512);
        decoration.setImage(CapellaUIPropertiesPlugin.getDefault().getImage("Lock_8x8.gif"));
        decoration.setDescriptionText("This field is locked");
        decoration.hide();
        this.getDecorationRegistry().put(control, decoration);
    }

    public void enable(Control control, boolean enabled) {
        if (control != null && !control.isDisposed()) {
            if (enabled) {
                Boolean previousState = this.getControlStatus().remove(control);
                if (previousState != null) {
                    control.setEnabled(previousState.booleanValue());
                } else {
                    control.setEnabled(enabled);
                }
            } else {
                this.getControlStatus().put(control, control.getEnabled());
                control.setEnabled(enabled);
            }
            this.update(control, enabled);
        }
    }

    public void update(Control control, boolean enabled) {
    }
}

