/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.providers;

import java.text.MessageFormat;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DView;
import org.eclipse.sirius.viewpoint.description.Viewpoint;
import org.eclipse.swt.graphics.Image;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.InformationsExchanger;
import org.polarsys.capella.common.ui.toolkit.viewers.data.DataLabelProvider;
import org.polarsys.capella.core.data.capellacore.NamedElement;
import org.polarsys.capella.core.data.cs.PhysicalLink;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentExchange;
import org.polarsys.capella.core.data.fa.FunctionalExchange;
import org.polarsys.capella.core.data.helpers.cs.services.PhysicalLinkExt;
import org.polarsys.capella.core.data.helpers.fa.services.FunctionExt;
import org.polarsys.capella.core.data.oa.CommunicationMean;
import org.polarsys.capella.core.data.oa.Entity;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaAdapterFactoryProvider;
import org.polarsys.capella.core.model.helpers.ComponentExchangeExt;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class CapellaTransfertViewerLabelProvider
extends DataLabelProvider {
    private static String PATTERN1 = " [{0} -> {1}]";
    private static String UNAMED = "<unnamed>";
    private boolean disableLabelComputation = CapellaUIPropertiesPlugin.getDefault().isDisableLabelComputation();

    public CapellaTransfertViewerLabelProvider() {
        this(null);
    }

    public CapellaTransfertViewerLabelProvider(TransactionalEditingDomain editingDomain) {
        super(editingDomain, CapellaAdapterFactoryProvider.getInstance().getAdapterFactory());
    }

    public Image getImage(Object object) {
        Viewpoint viewpoint;
        if (object instanceof DView && (viewpoint = ((DView)object).getViewpoint()) != null) {
            return this.getImage(viewpoint);
        }
        return super.getImage(object);
    }

    public String getText(Object object) {
        if (this.disableLabelComputation) {
            if (object instanceof AbstractNamedElement) {
                return ((AbstractNamedElement)object).getName();
            }
            if (object instanceof EObject) {
                return "[" + ((EObject)object).eClass().getName() + "]";
            }
            return UNAMED;
        }
        return this.doGetText(object);
    }

    private String doGetText(Object object) {
        AbstractFunction sourceElement = null;
        AbstractFunction targetElement = null;
        String sourceLabel = null;
        String targetLabel = null;
        if (object instanceof ComponentExchange && !(object instanceof CommunicationMean)) {
            ComponentExchange connection = (ComponentExchange)object;
            if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)connection))) {
                Collection sourceParts = ComponentExchangeExt.getSourceParts((ComponentExchange)connection);
                Collection targetParts = ComponentExchangeExt.getTargetParts((ComponentExchange)connection);
                sourceElement = (NamedElement)(sourceParts.size() > 0 ? sourceParts.toArray()[0] : null);
                targetElement = (NamedElement)(targetParts.size() > 0 ? targetParts.toArray()[0] : null);
            } else {
                sourceElement = ComponentExchangeExt.getSourceComponent((ComponentExchange)connection);
                targetElement = ComponentExchangeExt.getTargetComponent((ComponentExchange)connection);
            }
        } else if (object instanceof CommunicationMean) {
            ComponentExchange connection = (ComponentExchange)object;
            InformationsExchanger source = connection.getSource();
            InformationsExchanger target = connection.getTarget();
            if (source instanceof Entity && target instanceof Entity) {
                sourceElement = (Entity)source;
                targetElement = (Entity)target;
            }
        } else if (object instanceof FunctionalExchange) {
            FunctionalExchange exchange = (FunctionalExchange)object;
            sourceElement = FunctionExt.getIncomingAbstractFunction((FunctionalExchange)exchange);
            targetElement = FunctionExt.getOutGoingAbstractFunction((FunctionalExchange)exchange);
        } else if (object instanceof PhysicalLink) {
            PhysicalLink link = (PhysicalLink)object;
            if (CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)link))) {
                sourceElement = PhysicalLinkExt.getSourcePart((PhysicalLink)link);
                targetElement = PhysicalLinkExt.getTargetPart((PhysicalLink)link);
            } else {
                sourceElement = PhysicalLinkExt.getSourceComponent((PhysicalLink)link);
                targetElement = PhysicalLinkExt.getTargetComponent((PhysicalLink)link);
            }
        } else if (object instanceof DAnalysis) {
            Resource resource = ((DAnalysis)object).eResource();
            if (resource != null && resource.getURI() != null) {
                return resource.getURI().lastSegment();
            }
        } else if (object instanceof DView) {
            Viewpoint viewpoint = ((DView)object).getViewpoint();
            if (viewpoint != null) {
                if (viewpoint.eIsProxy()) {
                    return ((InternalEObject)viewpoint).eProxyURI().toString();
                }
                return viewpoint.getName();
            }
        } else {
            return super.getText(object);
        }
        sourceLabel = sourceElement == null || sourceElement.getName().equals("") ? UNAMED : sourceElement.getName();
        targetLabel = targetElement == null || targetElement.getName().equals("") ? UNAMED : targetElement.getName();
        return String.valueOf(super.getText(object)) + MessageFormat.format(PATTERN1, sourceLabel, targetLabel);
    }
}

