/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.viewers;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.core.data.capellacore.AbstractPropertyValue;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;
import org.polarsys.capella.core.ui.properties.viewers.ICellEditorProvider;
import org.polarsys.capella.core.ui.properties.viewers.IDelegatedViewer;

public abstract class AbstractDelegatedViewer
implements IDelegatedViewer {
    protected static final int DEFAULT_COLUMN_BOUND = 200;
    private Composite _viewerGroup;
    protected ColumnViewer _columnViewer;
    protected TabbedPropertySheetWidgetFactory _widgetFactory;
    private ICellEditorProvider _cellEditorProvider;
    private ISelection _selection;
    private List<ISelectionChangedListener> _listeners;

    public AbstractDelegatedViewer(TabbedPropertySheetWidgetFactory widgetFactory, ICellEditorProvider cellEditorProvider) {
        this._widgetFactory = widgetFactory;
        this._cellEditorProvider = cellEditorProvider;
    }

    public void createCellEditors(final Composite composite) {
        if (this.getCellEditorProvider() == null) {
            return;
        }
        final CellEditor[] cellEditors = new CellEditor[this.getColumnProperties().length];
        int i = 0;
        while (i < this.getColumnProperties().length) {
            cellEditors[i] = this.getCellEditorProvider().getCellEditor(composite, i, null);
            ++i;
        }
        this.getColumnViewer().setCellEditors(cellEditors);
        this.getColumnViewer().setColumnProperties(this.getColumnProperties());
        this.getColumnViewer().setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                if (AbstractDelegatedViewer.this.getColumnProperties()[1].equals(property)) {
                    cellEditors[1] = AbstractDelegatedViewer.this.getCellEditorProvider().getCellEditor(composite, 1, element);
                }
                return element instanceof AbstractPropertyValue;
            }

            public Object getValue(Object element, String property) {
                int i = 0;
                while (i < AbstractDelegatedViewer.this.getColumnProperties().length) {
                    if (AbstractDelegatedViewer.this.getColumnProperties()[i].equals(property)) {
                        return AbstractDelegatedViewer.this.getCellEditorProvider().getElementValue((EObject)element, i);
                    }
                    ++i;
                }
                return null;
            }

            public void modify(Object element, String property, Object value) {
                int i = 0;
                while (i < AbstractDelegatedViewer.this.getColumnProperties().length) {
                    if (AbstractDelegatedViewer.this.getColumnProperties()[i].equals(property)) {
                        AbstractDelegatedViewer.this.modifyElement((EObject)((Item)element).getData(), i, value);
                    }
                    ++i;
                }
            }
        });
    }

    @Override
    public ColumnViewer getColumnViewer() {
        return this._columnViewer;
    }

    public ICellEditorProvider getCellEditorProvider() {
        return this._cellEditorProvider;
    }

    protected void addViewerListeners() {
        if (this._columnViewer != null) {
            this._columnViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    AbstractDelegatedViewer.this.handleDoubleClick(event.getSelection());
                }
            });
            this._columnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    AbstractDelegatedViewer.this.setSelection(event.getSelection());
                }
            });
        }
    }

    protected boolean createViewerColumns() {
        return false;
    }

    protected String[] getColumnProperties() {
        return null;
    }

    protected void modifyElement(EObject element, int column, Object value) {
    }

    @Override
    public Composite getViewerGroup(Composite parent) {
        if (this._viewerGroup == null) {
            this._viewerGroup = new Composite(parent, 0);
            this._viewerGroup.setLayoutData((Object)new GridData(4, 4, true, true));
            GridLayout layout = new GridLayout(5, false);
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            this._viewerGroup.setLayout((Layout)layout);
        }
        return this._viewerGroup;
    }

    protected void handleDoubleClick(ISelection selection) {
        Object selectedElement;
        if (selection instanceof StructuredSelection && (selectedElement = ((StructuredSelection)selection).getFirstElement()) instanceof ModelElement) {
            CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)((ModelElement)selectedElement));
            this._columnViewer.refresh();
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._listeners == null) {
            this._listeners = new ArrayList<ISelectionChangedListener>();
        }
        this._listeners.add(listener);
    }

    public ISelection getSelection() {
        return this._selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this._listeners != null) {
            this._listeners.remove(listener);
        }
    }

    public void setSelection(ISelection selection) {
        this._selection = selection;
        for (ISelectionChangedListener listener : this._listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, this._selection));
        }
    }
}

