/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.wizards;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.help.HelpSystem;
import org.eclipse.help.IContext;
import org.eclipse.help.IHelpResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.HelpEvent;
import org.eclipse.swt.events.HelpListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.help.IWorkbenchHelpSystem;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.polarsys.capella.common.ui.services.helper.FormHelper;
import org.polarsys.capella.core.ui.properties.sections.IAbstractSection;
import org.polarsys.capella.core.ui.properties.wizards.CustomPropertyHelper;
import org.polarsys.capella.core.ui.properties.wizards.EditCapellaCustomPropertyWizard;
import org.polarsys.capella.core.ui.properties.wizards.Messages;
import org.polarsys.capella.core.ui.resources.CapellaUIResourcesPlugin;

public class EditCapellaCustomPropertyWizardPage
extends WizardPage {
    private FormToolkit toolkit;
    private HelpListener helpListener = null;
    private Composite comp = null;
    private Collection<ISection> sections = null;

    public EditCapellaCustomPropertyWizardPage(String pageName, EObject element, String metaclassLabel) {
        super(pageName);
        this.setTitle(metaclassLabel);
        this.setDescription(String.valueOf(Messages.EditCapellaCustomPropertyWizardPage_Description) + metaclassLabel);
        ImageDescriptor imageDescriptor = CapellaUIResourcesPlugin.getDefault().getPNGImage(element);
        if (imageDescriptor != null) {
            this.setImageDescriptor(imageDescriptor);
        }
    }

    private Composite createComposite(Composite parent, FormToolkit toolkit) {
        ScrolledForm scrolledContainer = toolkit.createScrolledForm(parent);
        this.setControl((Control)scrolledContainer);
        Composite content = scrolledContainer.getBody();
        content.setLayoutData((Object)new GridData(1808));
        content.setLayout((Layout)new GridLayout());
        return content;
    }

    public void createControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.toolkit.setBackground(parent.getBackground());
        Composite content = this.createComposite(parent, this.toolkit);
        this.initializeDialogUnits((Control)content);
        CTabFolder tabFolder = new CTabFolder(content, 2048);
        tabFolder.setLayoutData((Object)new GridData(1808));
        tabFolder.setSimple(false);
        EObject object = this.getEObject();
        Map<String, IAbstractSection> mySections = CustomPropertyHelper.getCustomPropertySection(object, "org.polarsys.capella.core.data.capellamodeller.properties", false);
        for (Map.Entry<String, IAbstractSection> entry : mySections.entrySet()) {
            IAbstractSection section = entry.getValue();
            if (!section.select(object)) continue;
            if (this.sections == null) {
                this.sections = new ArrayList<ISection>();
            }
            this.sections.add(section);
            Composite tabItemContent = new Composite((Composite)tabFolder, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            tabItemContent.setLayout((Layout)layout);
            CTabItem tabItem = new CTabItem(tabFolder, 0);
            tabItem.setControl((Control)tabItemContent);
            tabItem.setText(CustomPropertyHelper.getPropertyTabLabelFromID(entry.getKey()));
            section.setParentBackgroundColor(parent.getDisplay().getSystemColor(1));
            section.createControls(tabItemContent, null);
            section.loadData(object);
        }
        FormHelper.adaptBackgroundColor((Composite)content, (Color)content.getDisplay().getSystemColor(22), (boolean)false);
        final IWorkbenchHelpSystem helpSystem = PlatformUI.getWorkbench().getHelpSystem();
        final EClass eclass = object.eClass();
        if (this.comp != null && this.helpListener != null) {
            this.comp.removeHelpListener(this.helpListener);
        }
        this.helpListener = new HelpListener(){

            private boolean isHelpAvailable() {
                return this.checkIfHelpIsAvailable(eclass);
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected boolean checkIfHelpIsAvailable(EClass eclass2) {
                try {
                    Throwable throwable = null;
                    Object var3_5 = null;
                    try (InputStream inputStream = HelpSystem.getHelpContent((String)this.generateHTMLLink(eclass2));){
                        return eclass2 != null && inputStream != null;
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                            throw throwable;
                        }
                        if (throwable == throwable2) throw throwable;
                        throwable.addSuppressed(throwable2);
                        throw throwable;
                    }
                }
                catch (Exception exception) {
                    return false;
                }
            }

            public void helpRequested(HelpEvent e) {
                IContext c = new IContext(){

                    public String getText() {
                        if (!this.isHelpAvailable()) {
                            return NLS.bind((String)Messages.editCapellaCustomPropertyWizardPage_MainDescriptionKO, (Object)eclass.getName());
                        }
                        return null;
                    }

                    public IHelpResource[] getRelatedTopics() {
                        IHelpResource[] iHelpResourceArray;
                        IHelpResource hr = null;
                        if (this.isHelpAvailable()) {
                            hr = new IHelpResource(){

                                public String getLabel() {
                                    return NLS.bind((String)Messages.editCapellaCustomPropertyWizardPage_RLLinkName, (Object)eclass.getName());
                                }

                                public String getHref() {
                                    return this.generateHTMLLink(eclass);
                                }
                            };
                        }
                        if (hr != null) {
                            IHelpResource[] iHelpResourceArray2 = new IHelpResource[1];
                            iHelpResourceArray = iHelpResourceArray2;
                            iHelpResourceArray2[0] = hr;
                        } else {
                            iHelpResourceArray = null;
                        }
                        return iHelpResourceArray;
                    }
                };
                helpSystem.displayContext(c, 0, 0);
            }

            protected String generateHTMLLink(EClass eclass2) {
                return "/org.polarsys.capella.core.doc.user/html/editors/" + eclass2.getEPackage().getName() + '/' + eclass2.getName() + '.' + "html";
            }
        };
        this.comp = parent;
        this.comp.addHelpListener(this.helpListener);
    }

    public void dispose() {
        if (this.toolkit != null) {
            this.toolkit.dispose();
            this.toolkit = null;
        }
        if (this.comp != null && this.helpListener != null) {
            this.comp.removeHelpListener(this.helpListener);
            this.helpListener = null;
            this.comp.dispose();
            this.comp = null;
        }
        if (this.sections != null) {
            for (ISection section : this.sections) {
                section.dispose();
            }
            this.sections = null;
        }
    }

    protected EObject getEObject() {
        return ((EditCapellaCustomPropertyWizard)this.getWizard()).getEObject();
    }
}

