/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.activities;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.capella.core.transition.common.activities.AbstractActivity;
import org.polarsys.capella.core.transition.common.handlers.IHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.DefaultMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.traceability.ITraceabilityHandler;
import org.polarsys.capella.core.transition.common.merge.scope.IModelScopeFilter;
import org.polarsys.capella.core.transition.common.merge.scope.PartialRootedModelScope;
import org.polarsys.capella.core.transition.common.merge.scope.ReferenceModelScope;
import org.polarsys.capella.core.transition.common.merge.scope.TargetModelScope;
import org.polarsys.kitalpha.cadence.core.api.parameter.ActivityParameters;
import org.polarsys.kitalpha.transposer.api.ITransposerWorkflow;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class InitializeDiffMergeFromTransformationActivity
extends AbstractActivity
implements ITransposerWorkflow {
    public static final String ID = "org.polarsys.capella.core.transition.common.activities.InitializeDiffMergeFromTransformationActivity";

    @Override
    public IStatus _run(ActivityParameters activityParams) {
        IContext context = (IContext)activityParams.getParameter("TransposerContext").getValue();
        IStatus status = this.initializeTraceabilitySourceHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTraceabilityTargetHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeMergeHandler(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeReferenceScope(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        status = this.initializeTargetScope(context, activityParams);
        if (!this.checkStatus(status)) {
            return status;
        }
        return Status.OK_STATUS;
    }

    protected IStatus initializeReferenceScope(IContext context, ActivityParameters activityParams) {
        EObject sourceTop = (EObject)context.get((Object)"_Tr_T_R");
        context.put((Object)"MERGE_SOURCE_CONTAINER", (Object)sourceTop);
        ArrayList<EObject> rootSource = new ArrayList<EObject>();
        rootSource.add((EObject)context.get((Object)"MERGE_SOURCE_CONTAINER"));
        ReferenceModelScope sourceScope = new ReferenceModelScope(rootSource, context);
        context.put((Object)"MERGE_SOURCE_SCOPE", (Object)sourceScope);
        ((PartialRootedModelScope)sourceScope).build(this.getReferenceFilter(context));
        return Status.OK_STATUS;
    }

    protected IStatus initializeTargetScope(IContext context, ActivityParameters activityParams) {
        EObject targetTop = (EObject)context.get((Object)"_TTRo");
        context.put((Object)"MERGE_TARGET_CONTAINER", (Object)targetTop);
        ArrayList<EObject> rootTarget = new ArrayList<EObject>();
        rootTarget.add((EObject)context.get((Object)"MERGE_TARGET_CONTAINER"));
        TargetModelScope targetScope = new TargetModelScope((List<? extends EObject>)rootTarget, context);
        context.put((Object)"MERGE_TARGET_SCOPE", (Object)targetScope);
        ((PartialRootedModelScope)targetScope).build(this.getTargetFilter(context));
        return Status.OK_STATUS;
    }

    protected IStatus initializeMergeHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("MERGE_DIFFERENCES_HANDLER", activityParams);
        if (handler == null) {
            handler = new DefaultMergeHandler();
        }
        context.put((Object)"MERGE_DIFFERENCES_HANDLER", (Object)handler);
        IStatus status = handler.init(context);
        if (handler instanceof IMergeHandler) {
            this.initializeCategoriesHandlers(context, (IMergeHandler)handler, activityParams);
        }
        return status;
    }

    protected IStatus initializeCategoriesHandlers(IContext context, IMergeHandler handler, ActivityParameters activityParams) {
        return Status.OK_STATUS;
    }

    protected IStatus initializeTraceabilitySourceHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("TSMH", activityParams);
        if (handler == null) {
            handler = this.createDefaultTraceabilitySourceHandler(context);
        }
        context.put((Object)"TSMH", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultTraceabilitySourceHandler(IContext context) {
        return ITraceabilityHandler.DEFAULT;
    }

    protected IStatus initializeTraceabilityTargetHandler(IContext context, ActivityParameters activityParams) {
        IHandler handler = this.loadHandlerFromParameters("TTMH", activityParams);
        if (handler == null) {
            handler = this.createDefaultTraceabilityTargetHandler(context);
        }
        context.put((Object)"TTMH", (Object)handler);
        handler.init(context);
        return Status.OK_STATUS;
    }

    protected IHandler createDefaultTraceabilityTargetHandler(IContext context) {
        return ITraceabilityHandler.DEFAULT;
    }

    protected IModelScopeFilter getReferenceFilter(IContext context) {
        return new IModelScopeFilter(){

            @Override
            public boolean accepts(EObject element) {
                return true;
            }
        };
    }

    protected IModelScopeFilter getTargetFilter(IContext context) {
        return new IModelScopeFilter(){

            @Override
            public boolean accepts(EObject element) {
                return true;
            }
        };
    }
}

