/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.transposer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.polarsys.capella.core.transition.common.exception.TransitionException;
import org.polarsys.kitalpha.transposer.analyzer.graph.Edge;
import org.polarsys.kitalpha.transposer.analyzer.graph.Vertex;
import org.polarsys.kitalpha.transposer.scheduler.api.ITransposerTask;
import org.polarsys.kitalpha.transposer.scheduler.scheduler.impl.GenericTopologicalSorter;

public class ExtendedTopologicalSorter {
    protected Set<Edge<?>> backtracks;
    protected Set<Vertex<?>> model;
    protected LinkedHashSet<Vertex<?>> sortedModel;

    public Set<Edge<?>> getBacktracks() {
        return this.backtracks;
    }

    public Set<Vertex<?>> getModel() {
        return this.model;
    }

    public LinkedHashSet<Vertex<?>> getSortedModel() {
        return this.sortedModel;
    }

    public void dispose() {
        this.backtracks.clear();
        this.model.clear();
        this.sortedModel.clear();
        this.backtracks = null;
        this.model = null;
        this.sortedModel = null;
    }

    public ExtendedTopologicalSorter(Set<Vertex<?>> toSort, Set<Edge<?>> backtracks) {
        this.model = toSort;
        this.backtracks = backtracks;
    }

    private boolean isIndependantInTypeSet(Vertex<?> current, Set<Vertex<?>> toSort) {
        boolean independant = true;
        Iterator iterator = current.getOutgoingEdges().iterator();
        while (independant && iterator.hasNext()) {
            Edge currentedge = (Edge)iterator.next();
            if (this.backtracks.contains(currentedge)) {
                independant = true;
                continue;
            }
            Vertex currentType = currentedge.getTarget();
            boolean bl = independant = independant && !toSort.contains(currentType);
        }
        return independant;
    }

    private Set<Vertex<?>> findIndependantsInTypeSet(Set<Vertex<?>> toSort, IProgressMonitor monitor) {
        Set<Vertex<?>> independants = new HashSet();
        for (Vertex<?> currentType : toSort) {
            if (!this.isIndependantInTypeSet(currentType, toSort)) continue;
            independants.add(currentType);
            if (monitor == null) continue;
            monitor.worked(1 / this.model.size());
        }
        if (independants.isEmpty()) {
            this.lookForOtherBacktracks(toSort);
            independants = this.findIndependantsInTypeSet(toSort, monitor);
        }
        return independants;
    }

    private void lookForOtherBacktracks(Set<Vertex<?>> toSort) {
        ArrayList nonBacktrackedEdges = new ArrayList();
        ArrayList edgesToBreak = new ArrayList();
        for (Vertex<?> v : toSort) {
            ArrayList<Edge> breakables = new ArrayList<Edge>();
            for (Edge e : v.getOutgoingEdges()) {
                if (!toSort.contains(e.getTarget()) || e.isCritical() || this.backtracks.contains(e)) continue;
                breakables.add(e);
            }
            if (breakables.size() > 1) {
                edgesToBreak.addAll(breakables);
                continue;
            }
            nonBacktrackedEdges.addAll(breakables);
        }
        if (nonBacktrackedEdges.isEmpty()) {
            edgesToBreak.isEmpty();
        }
        if (!edgesToBreak.isEmpty()) {
            this.backtracks.addAll(edgesToBreak);
        } else {
            this.backtracks.addAll(nonBacktrackedEdges);
        }
    }

    public LinkedHashSet<Vertex<?>> sort(IProgressMonitor monitor) {
        if (monitor != null) {
            monitor.subTask("Topological sort");
        }
        this.sortedModel = this.topologicalSort(new LinkedHashSet(), this.model, monitor);
        return this.getSortedModel();
    }

    private LinkedHashSet<Vertex<?>> topologicalSort(LinkedHashSet<Vertex<?>> sorted, Set<Vertex<?>> toSort, IProgressMonitor monitor) {
        while (!toSort.isEmpty()) {
            Set<Vertex<?>> independants = this.findIndependantsInTypeSet(toSort, monitor);
            if (independants.isEmpty()) {
                throw new TransitionException((IStatus)new Status(4, "Transposer cycle exception", "Transposer cycle exception"));
            }
            toSort.removeAll(independants);
            sorted.addAll(independants);
        }
        return sorted;
    }

    public List<ITransposerTask<Vertex<?>>> getWork(IProgressMonitor monitor) {
        GenericTopologicalSorter sorter = new GenericTopologicalSorter(this.getModel(), this.getBacktracks()){

            public LinkedHashSet<Vertex<?>> getSortedModel() {
                return ExtendedTopologicalSorter.this.getSortedModel();
            }
        };
        return sorter.getWork(monitor);
    }
}

