/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.commands.CapellaCloneDiagramCommand;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.Messages;

public class CloneAction
extends BaseSelectionListenerAction {
    private Collection<DRepresentationDescriptor> _descriptors;
    protected TreeViewer _viewer;

    public CloneAction(TreeViewer viewer) {
        super(Messages.CloneAction_Title);
        this._viewer = viewer;
    }

    public void run() {
        CapellaCloneDiagramCommand command = new CapellaCloneDiagramCommand(this._descriptors);
        command.addCloneListener(new CapellaCloneDiagramCommand.ICloneListener(){

            public void cloneAboutToBeRemoved(final DRepresentation clone, Session session) {
                if (CloneAction.this._viewer != null) {
                    Runnable removeRunnable = new Runnable(){

                        @Override
                        public void run() {
                            (this).CloneAction.this._viewer.remove((Object)clone);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(removeRunnable);
                    } else {
                        removeRunnable.run();
                    }
                }
            }

            public void cloneCreated(final DRepresentation clone, final Session session) {
                if (CloneAction.this._viewer != null) {
                    Runnable addRunnable = new Runnable(){

                        @Override
                        public void run() {
                            EObject parent = ((DSemanticDecorator)clone).getTarget();
                            (this).CloneAction.this._viewer.add((Object)parent, (Object)clone);
                            SessionManager.INSTANCE.notifyRepresentationCreated(session);
                        }
                    };
                    if (Display.getCurrent() == null) {
                        PlatformUI.getWorkbench().getDisplay().asyncExec(addRunnable);
                    } else {
                        addRunnable.run();
                    }
                }
            }
        });
        TransactionHelper.getEditingDomain(this._descriptors).getCommandStack().execute((Command)command);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        List selectedElements = selection.toList();
        this._descriptors = RepresentationHelper.getSelectedDescriptors((Collection)selectedElements);
        int size = selectedElements.size();
        return size > 0 && size == this._descriptors.size();
    }
}

