/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.ShowInContext;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.ui.services.helper.EObjectImageProviderHelper;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.model.handler.helpers.CapellaProjectHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.CapellaNavigatorPlugin;

public class LocateInCapellaExplorerAction
implements IObjectActionDelegate,
IViewActionDelegate {
    private boolean ignoreWorkbenchPartSite;
    private IWorkbenchPartSite site;
    ISelection selection = null;

    public static IAction createLocateTowards(final EObject referenced, String message, boolean useElementIcon) {
        final LocateInCapellaExplorerAction goToAction = new LocateInCapellaExplorerAction(){

            @Override
            protected ISelection getSelection() {
                return new StructuredSelection((Object)referenced);
            }

            @Override
            public void run(IAction action) {
                EObject elementToSelectInCapellaExplorer = referenced;
                this.selectElementInCapellaExplorer((ISelection)new StructuredSelection((Object)elementToSelectInCapellaExplorer));
            }
        };
        Action action = new Action(){

            public void run() {
                goToAction.run((IAction)this);
            }
        };
        goToAction.shouldIgnoreWorkbenchPartSite(true);
        if (useElementIcon) {
            action.setImageDescriptor(ImageDescriptor.createFromImage((Image)EObjectImageProviderHelper.getImage((EObject)referenced)));
        } else {
            action.setImageDescriptor(CapellaNavigatorPlugin.getDefault().getImageDescriptor("capella_16.png"));
        }
        action.setText(NLS.bind((String)message, (Object)EObjectLabelProviderHelper.getText((EObject)referenced)));
        return action;
    }

    protected Object getFirstSelectedElement(ISelection selection) {
        if (selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        return structuredSelection.getFirstElement();
    }

    protected ISelection getSelection() {
        return this.selection;
    }

    public void init(IViewPart view) {
        this.site = view.getSite();
    }

    public void run(IAction action) {
        if ((this.ignoreWorkbenchPartSite || this.site != null) && this.selection instanceof IStructuredSelection) {
            this.selectElementInCapellaExplorer(this.selection);
        }
    }

    protected void selectElementInCapellaExplorer(ISelection selection) {
        IViewPart part;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (part = window.getActivePage().findView("capella.project.explorer")) != null) {
            IShowInTarget showInTarget = (IShowInTarget)part.getAdapter(IShowInTarget.class);
            showInTarget.show(new ShowInContext(null, selection));
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.site = targetPart.getSite();
    }

    public void setSite(IWorkbenchPartSite site) {
        this.site = site;
    }

    public void shouldIgnoreWorkbenchPartSite(boolean ignore) {
        this.ignoreWorkbenchPartSite = ignore;
    }

    public static Object getElement(Object uiSelectedElement) {
        boolean allowMultiplePart;
        EObject semanticElement = CapellaAdapterHelper.resolveSemanticObject((Object)uiSelectedElement, (boolean)true);
        if (semanticElement instanceof Part && !(allowMultiplePart = CapellaProjectHelper.TriStateBoolean.True.equals((Object)CapellaProjectHelper.isReusableComponentsDriven((EObject)((Part)semanticElement)))) && !(((Part)semanticElement).getAbstractType() instanceof ConfigurationItem)) {
            semanticElement = ((Part)semanticElement).getAbstractType();
        }
        return semanticElement;
    }
}

