/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.actions.TextActionHandler;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.interaction.SequenceMessage;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.model.handler.provider.CapellaReadOnlyHelper;
import org.polarsys.capella.core.model.handler.provider.IReadOnlySectionHandler;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;
import org.polarsys.capella.core.ui.toolkit.AbstractCommandActionHandler;

public class RenameAction
extends AbstractCommandActionHandler {
    private Tree _navigatorTree;
    private Composite _textEditorParent;
    private TreeEditor _treeEditor;
    private Text _textEditor;
    private TextActionHandler _textActionHandler;

    public RenameAction(CapellaCommonNavigator commonNavigator_p) {
        super("");
        this._navigatorTree = commonNavigator_p.getCommonViewer().getTree();
        this._treeEditor = new TreeEditor(this._navigatorTree);
    }

    private Composite createParent() {
        Composite result = new Composite((Composite)this._navigatorTree, 0);
        TreeItem[] selectedItems = this._navigatorTree.getSelection();
        this._treeEditor.horizontalAlignment = 16384;
        this._treeEditor.grabHorizontal = true;
        this._treeEditor.setEditor((Control)result, selectedItems[0]);
        return result;
    }

    private void createTextEditor(EObject selectedElement_p) {
        this._textEditorParent = this.createParent();
        this._textEditorParent.setVisible(false);
        final int inset = RenameAction.getCellEditorInset((Control)this._textEditorParent);
        if (inset > 0) {
            this._textEditorParent.addListener(9, new Listener(){

                public void handleEvent(Event e) {
                    Point textSize = RenameAction.this._textEditor.getSize();
                    Point parentSize = RenameAction.this._textEditorParent.getSize();
                    e.gc.drawRectangle(0, 0, Math.min(textSize.x + 4, parentSize.x - 1), parentSize.y - 1);
                }
            });
        }
        this._textEditor = new Text(this._textEditorParent, 0);
        this._textEditor.setFont(this._navigatorTree.getFont());
        this._textEditorParent.setBackground(this._textEditor.getBackground());
        IReadOnlySectionHandler handler = CapellaReadOnlyHelper.getReadOnlySectionHandler();
        if (handler != null) {
            this._textEditor.setEditable(!handler.isLockedByOthers(selectedElement_p));
        }
        this._textEditor.addListener(24, new Listener(){

            public void handleEvent(Event e) {
                Point textSize = RenameAction.this._textEditor.computeSize(-1, -1);
                textSize.x += textSize.y;
                Point parentSize = RenameAction.this._textEditorParent.getSize();
                RenameAction.this._textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
                RenameAction.this._textEditorParent.redraw();
            }
        });
        this._textEditor.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                switch (event.detail) {
                    case 2: {
                        RenameAction.this.disposeTextWidget();
                        event.doit = true;
                        event.detail = 0;
                        break;
                    }
                    case 4: {
                        RenameAction.this.saveChangesAndDispose();
                        event.doit = true;
                        event.detail = 0;
                    }
                }
            }
        });
        this._textEditor.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent fe) {
                RenameAction.this.saveChangesAndDispose();
            }
        });
        if (this._textActionHandler != null) {
            this._textActionHandler.addText(this._textEditor);
        }
    }

    private void disposeTextWidget() {
        if (this._textActionHandler != null) {
            this._textActionHandler.removeText(this._textEditor);
            this._textActionHandler.dispose();
            this._textActionHandler = null;
        }
        if (this._textEditorParent != null) {
            this._textEditorParent.dispose();
            this._textEditorParent = null;
            this._textEditor = null;
            this._treeEditor.setEditor(null, null);
        }
    }

    public void run() {
        EObject selectedElement = (EObject)this.getStructuredSelection().getFirstElement();
        this.queryNewNameInline(selectedElement);
    }

    public boolean updateSelection(IStructuredSelection selection_p) {
        Object selectedElement;
        boolean result = false;
        if (!selection_p.isEmpty() && (selectedElement = selection_p.getFirstElement()) instanceof EObject && !(selectedElement instanceof SequenceMessage)) {
            result = true;
        }
        return result;
    }

    private void queryNewNameInline(EObject selectedElement_p) {
        if (this._textEditorParent == null) {
            this.createTextEditor(selectedElement_p);
        }
        EAttribute attribute = CapellaResourceHelper.getEditableAttribute((EObject)selectedElement_p);
        String name = null;
        if (attribute != null) {
            name = (String)selectedElement_p.eGet((EStructuralFeature)attribute);
        }
        this._textEditor.setText(name != null ? name : "");
        this._textEditorParent.setVisible(true);
        Point textSize = this._textEditor.computeSize(-1, -1);
        textSize.x += textSize.y;
        Point parentSize = this._textEditorParent.getSize();
        int inset = RenameAction.getCellEditorInset((Control)this._textEditorParent);
        this._textEditor.setBounds(2, inset, Math.min(textSize.x, parentSize.x - 4), parentSize.y - 2 * inset);
        this._textEditorParent.redraw();
        this._textEditor.selectAll();
        this._textEditor.setFocus();
    }

    private void saveChangesAndDispose() {
        EObject selectedElement = (EObject)this.getStructuredSelection().getFirstElement();
        String newName = this._textEditor.getText();
        if (selectedElement != null) {
            EAttribute attribute = CapellaResourceHelper.getEditableAttribute((EObject)selectedElement);
            String selectedElementName = null;
            if (attribute != null) {
                selectedElementName = (String)selectedElement.eGet((EStructuralFeature)attribute);
            }
            if (newName != null && !newName.equals(selectedElementName)) {
                TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)selectedElement);
                domain.getCommandStack().execute(SetCommand.create((EditingDomain)domain, (Object)selectedElement, (Object)attribute, (Object)newName));
            }
        }
        this.disposeTextWidget();
        if (this._navigatorTree != null && !this._navigatorTree.isDisposed()) {
            this._navigatorTree.setFocus();
        }
    }

    private static int getCellEditorInset(Control control_p) {
        return 1;
    }

    public void setTextActionHandler(TextActionHandler actionHandler) {
        this._textActionHandler = actionHandler;
    }
}

