/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation.Messages;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.representation.MoveRepresentationAction;

public class MoveRepresentationMenuManager
extends MenuManager
implements ISelectionChangedListener {
    public MoveRepresentationMenuManager() {
        super(Messages.RepresentationActionProvider_MovediagramSubMenu_Title, "MoveDiagrams.Menu.ID");
    }

    public void initializeSubMenus(ISelection selection) {
        this.removeAll();
        List selectionList = ((IStructuredSelection)selection).toList();
        Collection descriptors = RepresentationHelper.getSelectedDescriptors((Collection)selectionList);
        if (!descriptors.isEmpty()) {
            Session session = null;
            List sessions = descriptors.stream().map(DRepresentationDescriptor::getTarget).map(arg_0 -> ((SessionManager)SessionManager.INSTANCE).getSession(arg_0)).distinct().filter(Objects::nonNull).collect(Collectors.toList());
            if (sessions.size() == 1) {
                session = (Session)sessions.get(0);
            }
            ArrayList availableTargetResources = session == null ? new ArrayList() : new ArrayList(((DAnalysisSession)session).getAllSessionResources());
            Collection representationResources = descriptors.stream().map(EObject::eResource).collect(Collectors.toSet());
            availableTargetResources.removeAll(representationResources);
            if (!availableTargetResources.isEmpty()) {
                for (Resource availableTargetResource : availableTargetResources) {
                    Collection availableDAnalysys = EcoreUtil.getObjectsByType((Collection)availableTargetResource.getContents(), (EClassifier)ViewpointPackage.eINSTANCE.getDAnalysis());
                    for (DAnalysis dAnalysis : availableDAnalysys) {
                        MoveRepresentationAction action = new MoveRepresentationAction((DAnalysisSession)session, descriptors, dAnalysis);
                        this.add((IAction)action);
                    }
                }
            }
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        this.initializeSubMenus(selection);
    }
}

