/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.transition.common.ui.handlers.merge;

import java.util.Collection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.ui.util.DiffMergeDialog;
import org.eclipse.emf.diffmerge.ui.viewers.AbstractComparisonViewer;
import org.eclipse.emf.diffmerge.ui.viewers.DefaultUserProperties;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.core.transition.common.handlers.merge.DefaultMergeHandler;
import org.polarsys.capella.core.transition.common.handlers.merge.IMergeHandler;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.DiffComparisonViewer;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.MergeEMFDiffNode;
import org.polarsys.capella.core.transition.common.ui.handlers.merge.Messages;
import org.polarsys.kitalpha.transposer.rules.handler.rules.api.IContext;

public class MergeUIDifferencesHandler
extends DefaultMergeHandler {
    public IStatus processDifferences(IContext context, Collection<IDifference> diffSource, Collection<IDifference> diffTarget) {
        MergeEMFDiffNode diffNode = this.createDiffNode(context);
        return this.displayDifferences(context, diffNode);
    }

    protected IStatus displayDifferences(final IContext context, final MergeEMFDiffNode diffNode) {
        final Integer[] result = new Integer[]{0};
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                DiffMergeDialog dialog = MergeUIDifferencesHandler.this.createDiffDialog(context, display, diffNode);
                result[0] = dialog.open();
            }
        });
        if (result[0] == 1) {
            return Status.CANCEL_STATUS;
        }
        return Status.OK_STATUS;
    }

    protected DiffMergeDialog createDiffDialog(final IContext context, Display display, final MergeEMFDiffNode diffNode) {
        DiffMergeDialog dialog = new DiffMergeDialog(display.getActiveShell(), (String)context.get((Object)"COMMAND_NAME"), diffNode){
            private static final int ID_APPLY_ALL_CHANGES = 1025;
            private DiffComparisonViewer viewer;

            protected void createButtonsForButtonBar(Composite parent) {
                Button applyAllChangesButton;
                this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
                if (this._input.isEditionPossible(false)) {
                    applyAllChangesButton = this.createButton(parent, 1025, Messages.MergeUIDifferencesHandler_ApplyAllChanges, false);
                    applyAllChangesButton.setEnabled(((MergeEMFDiffNode)this._input).isMergeAllEnabled(true));
                }
                this.createOKButton(parent);
                applyAllChangesButton = this.getButton(1025);
                if (applyAllChangesButton != null) {
                    parent.getShell().setDefaultButton(applyAllChangesButton);
                }
            }

            protected AbstractComparisonViewer createComparisonViewer(Composite parent) {
                this.viewer = new DiffComparisonViewer(parent){

                    protected void registerCategories(EMFDiffNode node) {
                        super.registerCategories(node);
                        MergeUIDifferencesHandler.this.initializeCategories(context, diffNode);
                    }
                };
                this.viewer.addPropertyChangeListener(new IPropertyChangeListener(){

                    public void propertyChange(PropertyChangeEvent event) {
                        Button applyAllChangesButton = this.getButton(1025);
                        if (applyAllChangesButton != null && ("PROPERTY_CURRENT_INPUT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_LEFT".equals(event.getProperty()) || "PROPERTY_ACTIVATION_MERGE_TO_RIGHT".equals(event.getProperty()))) {
                            applyAllChangesButton.setEnabled(((MergeEMFDiffNode)_input).isMergeAllEnabled(true));
                        }
                    }
                });
                return this.viewer;
            }

            protected void buttonPressed(int buttonId) {
                if (buttonId == 1025) {
                    if (this.viewer.mergeAll()) {
                        this.okPressed();
                    }
                } else {
                    super.buttonPressed(buttonId);
                }
            }
        };
        return dialog;
    }

    protected MergeEMFDiffNode createDiffNode(IContext context) {
        TransactionalEditingDomain domain = (TransactionalEditingDomain)context.get((Object)"TRANSITION_TARGET_EDITING_DOMAIN");
        MergeEMFDiffNode diffNode = new MergeEMFDiffNode(context, (EditingDomain)domain, true, false);
        diffNode.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_INCREMENTAL_MODE, true);
        diffNode.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_COVER_CHILDREN, true);
        diffNode.setUserPropertyValue(DefaultUserProperties.P_DEFAULT_SHOW_MERGE_IMPACT, true);
        diffNode.setUserPropertyValue(DefaultUserProperties.P_SUPPORT_UNDO_REDO, false);
        diffNode.setLeftRole(Role.REFERENCE);
        diffNode.setMergeAllOnLeft(true);
        diffNode.setMergeAllOnRight(false);
        return diffNode;
    }

    protected void initializeCategories(IContext context, MergeEMFDiffNode diffNode) {
        diffNode.getCategoryManager().initialize((IMergeHandler)this);
    }
}

