/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.clipboard.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.clipboard.core.ClipboardUtil;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;
import org.polarsys.capella.core.platform.sirius.clipboard.util.CapellaDiagramFormatDataManager;
import org.polarsys.capella.core.platform.sirius.clipboard.util.LayerUtil;

public class CapellaDiagramClipboard {
    private static final CapellaDiagramClipboard INSTANCE = new CapellaDiagramClipboard();
    private final List<View> _gmfElements = new ArrayList<View>();
    private final List<DSemanticDecorator> _siriusElements = new ArrayList<DSemanticDecorator>();
    private String _data = null;
    private final CapellaDiagramFormatDataManager formatDataManager = new CapellaDiagramFormatDataManager();

    public static CapellaDiagramClipboard getInstance() {
        return INSTANCE;
    }

    protected CapellaDiagramClipboard() {
    }

    public void copy(List<? extends View> toCopy) {
        assert (toCopy != null);
        this.clear();
        this._gmfElements.addAll(toCopy);
        this._siriusElements.addAll(LayerUtil.toSirius(this._gmfElements));
        ArrayList<Object> toSerialize = new ArrayList<Object>();
        if (!this._siriusElements.isEmpty()) {
            toSerialize.addAll(this._siriusElements);
            for (DSemanticDecorator siriusElement : this._siriusElements) {
                this.formatDataManager.storeFormatData(LayerUtil.getGraphicalPart(siriusElement));
            }
        } else {
            toSerialize.addAll(this._gmfElements);
        }
        this._data = ClipboardUtil.copyElementsToString(toSerialize, null, null);
    }

    public void applyFormat(Map<? extends DSemanticDecorator, ? extends DSemanticDecorator> pastedToCopiedElements, IGraphicalEditPart pastedEditPart, boolean applyLayout, boolean applyStyle) {
        this.formatDataManager.setPastedToCopiedElement(pastedToCopiedElements);
        if (applyLayout && applyStyle) {
            this.formatDataManager.applyFormat(pastedEditPart);
        } else if (applyLayout) {
            this.formatDataManager.applyLayout(pastedEditPart);
        } else if (applyStyle) {
            this.formatDataManager.applyStyle(pastedEditPart);
        }
        this.formatDataManager.setPastedToCopiedElement(null);
    }

    public void clear() {
        this._data = null;
        this._siriusElements.clear();
        this._gmfElements.clear();
        this.formatDataManager.clearFormatData();
    }

    public boolean isEmpty() {
        return this._data == null || this._siriusElements.isEmpty() || this._gmfElements.isEmpty();
    }

    public String getSiriusData() {
        return this._data;
    }

    public List<DSemanticDecorator> getSiriusElements() {
        return Collections.unmodifiableList(this._siriusElements);
    }

    public List<View> getGmfElements() {
        return Collections.unmodifiableList(this._gmfElements);
    }
}

