/*******************************************************************************
 * Copyright (c) 2017 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/
package org.polarsys.capella.core.data.gen.edit.decorators;

import org.eclipse.emf.edit.provider.IItemLabelProvider;

/**
 * @author Joao Barata
 */
public interface IDelegatedDecorator extends IItemLabelProvider {

  /**
   * This service allows to enable or disable this decorator according to a given context
   * @param object the object context
   * @return TRUE if this decorator has to be activated, FALSE otherwise
   */
  boolean appliesTo(Object object);
}
