/*******************************************************************************
 * Copyright (c) 2006, 2016 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

package org.polarsys.capella.core.model.helpers;

import java.util.List;

import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.communication.Message;

/**
 */
public class MessageExt {
  static public List<Message> getAllMessages;

  /**
   * This method returns the root owner {@link MessagePkg} of the current {@link Message}
   * @param message
   *          the current message
   * @return the root owner DataPkg
   */
  static public DataPkg getRootOwnerDataPkg(Message message) {
    if (null != message) {
      Object container = message.eContainer();
      if (container instanceof Message) {
        return getRootOwnerDataPkg((Message) container);
      } else if (container instanceof DataPkg) {
        return DataPkgExt.getRootDataPkg((DataPkg) container);
      }
    }
    return null;
  }
}
