/*******************************************************************************
 * Copyright (c) 2006, 2018 THALES GLOBAL SERVICES.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *  
 * Contributors:
 *    Thales - initial API and implementation
 *******************************************************************************/

package org.polarsys.capella.core.data.helpers.la.delegates;

import org.eclipse.emf.ecore.EStructuralFeature;

import org.polarsys.capella.core.data.helpers.cs.delegates.ComponentAllocationHelper;
import org.polarsys.capella.core.data.la.SystemRealization;

public class SystemRealizationHelper {
  private static SystemRealizationHelper instance;

  private SystemRealizationHelper() {
    // do nothing
  }

  public static SystemRealizationHelper getInstance() {
    if (instance == null) {
    	instance = new SystemRealizationHelper();
    }
    return instance;
  }

  public Object doSwitch(SystemRealization element, EStructuralFeature feature) {
    // no helper found... searching in super classes...
	  return ComponentAllocationHelper.getInstance().doSwitch(element, feature);
  }
}
