/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.ctx.services;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.ctx.Capability;
import org.polarsys.capella.core.data.ctx.CapabilityExploitation;
import org.polarsys.capella.core.data.ctx.Mission;
import org.polarsys.capella.core.data.ctx.MissionInvolvement;
import org.polarsys.capella.core.data.ctx.SystemComponent;

public class MissionExt {
    public static List<Capability> getExploitedCapabilities(Mission mission) {
        ArrayList<Capability> exploitedCapabilities = new ArrayList<Capability>();
        EList exploitationSet = mission.getOwnedCapabilityExploitations();
        for (CapabilityExploitation exploit : exploitationSet) {
            Capability capability = exploit.getCapability();
            if (capability == null) continue;
            exploitedCapabilities.add(capability);
        }
        return exploitedCapabilities;
    }

    public static void removeInvolvedSystemComponent(Mission mission, SystemComponent component) {
        List missionInvolvementsToRemove = mission.getOwnedMissionInvolvements().stream().filter(involvement -> involvement.getSystemComponent() == component).collect(Collectors.toList());
        for (MissionInvolvement involvement2 : missionInvolvementsToRemove) {
            involvement2.destroy();
        }
    }

    public static void removeExploitedCapabilities(Mission mission, List<Capability> useCases) {
        ArrayList<CapabilityExploitation> removedLinks = new ArrayList<CapabilityExploitation>();
        for (Object capabilityExp : mission.getOwnedCapabilityExploitations()) {
            CapabilityExploitation capabilitExploitation = (CapabilityExploitation)capabilityExp;
            if (!useCases.contains(capabilitExploitation.getCapability())) continue;
            removedLinks.add(capabilitExploitation);
        }
        for (CapabilityExploitation capabilityExploitation : removedLinks) {
            capabilityExploitation.destroy();
        }
    }
}

