/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.delegates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.polarsys.capella.common.data.modellingcore.AbstractTrace;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.core.data.fa.AbstractFunction;
import org.polarsys.capella.core.data.fa.ComponentFunctionalAllocation;
import org.polarsys.capella.core.data.fa.FunctionRealization;
import org.polarsys.capella.core.data.helpers.fa.delegates.AbstractFunctionHelper;
import org.polarsys.capella.core.data.la.LogicalFunction;
import org.polarsys.capella.core.data.pa.PaPackage;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.data.pa.PhysicalFunction;

public class PhysicalFunctionHelper {
    private static PhysicalFunctionHelper instance;

    private PhysicalFunctionHelper() {
    }

    public static PhysicalFunctionHelper getInstance() {
        if (instance == null) {
            instance = new PhysicalFunctionHelper();
        }
        return instance;
    }

    public Object doSwitch(PhysicalFunction element, EStructuralFeature feature) {
        List<PhysicalFunction> ret = null;
        if (feature.equals(PaPackage.Literals.PHYSICAL_FUNCTION__ALLOCATING_PHYSICAL_COMPONENTS)) {
            ret = this.getAllocatingPhysicalComponents(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_FUNCTION__REALIZED_LOGICAL_FUNCTIONS)) {
            ret = this.getRealizedLogicalFunctions(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_FUNCTION__CONTAINED_PHYSICAL_FUNCTIONS)) {
            ret = this.getContainedPhysicalFunctions(element);
        } else if (feature.equals(PaPackage.Literals.PHYSICAL_FUNCTION__CHILDREN_PHYSICAL_FUNCTIONS)) {
            ret = this.getChildrenPhysicalFunctions(element);
        }
        if (ret == null) {
            ret = AbstractFunctionHelper.getInstance().doSwitch((AbstractFunction)element, feature);
        }
        return ret;
    }

    protected List<PhysicalComponent> getAllocatingPhysicalComponents(PhysicalFunction element) {
        ArrayList<PhysicalComponent> ret = new ArrayList<PhysicalComponent>();
        for (AbstractTrace trace : element.getIncomingTraces()) {
            TraceableElement src;
            if (!(trace instanceof ComponentFunctionalAllocation) || !((src = trace.getSourceElement()) instanceof PhysicalComponent)) continue;
            ret.add((PhysicalComponent)src);
        }
        return ret;
    }

    protected List<LogicalFunction> getRealizedLogicalFunctions(PhysicalFunction element) {
        ArrayList<LogicalFunction> ret = new ArrayList<LogicalFunction>();
        for (FunctionRealization functionRealization : element.getOutFunctionRealizations()) {
            AbstractFunction abstractFunction = functionRealization.getAllocatedFunction();
            if (!(abstractFunction instanceof LogicalFunction)) continue;
            ret.add((LogicalFunction)abstractFunction);
        }
        return ret;
    }

    protected List<PhysicalFunction> getContainedPhysicalFunctions(PhysicalFunction element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (AbstractFunction function : element.getOwnedFunctions()) {
            if (!(function instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)function);
        }
        return ret;
    }

    protected List<PhysicalFunction> getChildrenPhysicalFunctions(PhysicalFunction element) {
        ArrayList<PhysicalFunction> ret = new ArrayList<PhysicalFunction>();
        for (AbstractFunction function : element.getSubFunctions()) {
            if (!(function instanceof PhysicalFunction)) continue;
            ret.add((PhysicalFunction)function);
        }
        return ret;
    }
}

