/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.helpers.pa.services;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.cs.AbstractDeploymentLink;
import org.polarsys.capella.core.data.cs.DeployableElement;
import org.polarsys.capella.core.data.cs.DeploymentTarget;
import org.polarsys.capella.core.data.pa.PhysicalComponentPkg;
import org.polarsys.capella.core.data.pa.deployment.ComponentInstance;
import org.polarsys.capella.core.data.pa.deployment.DeploymentFactory;
import org.polarsys.capella.core.data.pa.deployment.TypeDeploymentLink;

public class ComponentInstanceExt {
    public static void addDeployedElement(ComponentInstance location, ComponentInstance deployedElement) {
        TypeDeploymentLink link = DeploymentFactory.eINSTANCE.createTypeDeploymentLink();
        CapellaElement cont = (CapellaElement)location.eContainer().eContainer().eContainer();
        if (cont != null) {
            ((PhysicalComponentPkg)cont).getOwnedDeployments().add((Object)link);
        }
        link.setLocation((DeploymentTarget)location);
        link.setDeployedElement((DeployableElement)deployedElement);
    }

    public static void addDeployerElement(ComponentInstance deployedElement, ComponentInstance location) {
        ComponentInstanceExt.addDeployedElement(location, deployedElement);
    }

    public static boolean isDeployedOn(ComponentInstance location, ComponentInstance deployedElement) {
        EList deployments = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            if (!abstractDeployment.getDeployedElement().equals(deployedElement)) continue;
            return true;
        }
        return false;
    }

    public static List<ComponentInstance> getDeployedElements(ComponentInstance location) {
        ArrayList<ComponentInstance> deployedElements = new ArrayList<ComponentInstance>(1);
        EList deployments = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            ComponentInstance deployedElement = (ComponentInstance)abstractDeployment.getDeployedElement();
            if (deployedElement == null) continue;
            deployedElements.add(deployedElement);
        }
        return deployedElements;
    }

    public static List<ComponentInstance> getDeploymentTargets(ComponentInstance element) {
        ArrayList<ComponentInstance> deploymentTargets = new ArrayList<ComponentInstance>();
        EList deployments = element.getDeployingLinks();
        for (AbstractDeploymentLink abstractDeployment : deployments) {
            ComponentInstance location = (ComponentInstance)abstractDeployment.getLocation();
            if (location == null) continue;
            deploymentTargets.add(location);
        }
        return deploymentTargets;
    }

    public static void undeployElement(ComponentInstance location, ComponentInstance deployedElement) {
        ArrayList<AbstractDeploymentLink> elementsToDelete = new ArrayList<AbstractDeploymentLink>();
        EList deployements = location.getDeploymentLinks();
        for (AbstractDeploymentLink abstractDeployment : deployements) {
            if (!abstractDeployment.getDeployedElement().equals(deployedElement)) continue;
            elementsToDelete.add(abstractDeployment);
        }
        for (AbstractDeploymentLink toDelete : elementsToDelete) {
            toDelete.destroy();
        }
    }
}

