/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.wizards;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.views.properties.PropertySheet;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.properties.wizards.CustomWizardHandler;
import org.polarsys.capella.core.ui.properties.wizards.ICustomWizardHandler;
import org.polarsys.capella.core.ui.properties.wizards.Messages;

public class OpenCustomWizardCommand
extends AbstractReadWriteCommand {
    public static final String PROPERTIES_SHEET_VIEW_ID = "org.eclipse.ui.views.PropertySheet";
    protected EObject object;
    private boolean canceled;

    public OpenCustomWizardCommand(EObject object) {
        this.object = object;
    }

    public boolean canExecute() {
        return TransactionHelper.getExecutionManager((EObject)this.object) != null;
    }

    public void run() {
        this.canceled = false;
        if (!this.createCustomWizardHandler().openWizard(this.object)) {
            this.canceled = true;
            throw new OperationCanceledException();
        }
        this.refreshPropertiesView(this.object);
    }

    public String getName() {
        return Messages.CustomWizardHandler_Command_Title;
    }

    public Collection<?> getAffectedObjects() {
        return Collections.singletonList(this.object);
    }

    public void commandRolledBack() {
        this.canceled = true;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    protected ICustomWizardHandler createCustomWizardHandler() {
        return new CustomWizardHandler();
    }

    private final void refreshPropertiesView(EObject object) {
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        PropertySheet propertyView = (PropertySheet)activePage.findView(PROPERTIES_SHEET_VIEW_ID);
        if (propertyView != null) {
            propertyView.selectionChanged(activePage.getActivePart(), (ISelection)new StructuredSelection((Object)object));
        }
    }
}

