/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.preference.ui;

import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.polarsys.kitalpha.ad.ta.extension.TargetApplicationExtensionManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.preference.Activator;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.preference.internal.Messages;

public class ViewpointDslPreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private final IPreferenceStore store = Activator.getDefault().getPreferenceStore();
    private ComboFieldEditor defautTA;
    private BooleanFieldEditor useTAValue;
    private StringFieldEditor rpnField;
    private Group group;

    public ViewpointDslPreferencesPage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        this.createGroup();
        this.useTAValue = new BooleanFieldEditor("UseTAViewpointRootProjectName", Messages.USE_TA_VALUE_FIELD_LABEL, (Composite)this.group);
        this.addField((FieldEditor)this.useTAValue);
        this.rpnField = new StringFieldEditor("ViewpointRootProjectName", Messages.RPN_FIELD_LABEL, (Composite)this.group);
        this.rpnField.setEmptyStringAllowed(this.store.getBoolean("UseTAViewpointRootProjectName"));
        this.rpnField.setErrorMessage(Messages.RPN_FIELD_VALUE_ERROR);
        this.addField((FieldEditor)this.rpnField);
        this.defautTA = this.createDefaultTAPreferenceWidget();
        this.addField((FieldEditor)this.defautTA);
        this.handlePreferencesDefaultValues();
    }

    protected void performDefaults() {
        super.performDefaults();
        this.getPreferenceStore().setDefault("UseTAViewpointRootProjectName", true);
        this.rpnField.setEnabled(false, (Composite)this.group);
    }

    protected void checkState() {
        this.rpnField.setEmptyStringAllowed(this.useTAValue.getBooleanValue());
        super.checkState();
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource().equals(this.useTAValue)) {
            this.rpnField.setEnabled(!this.useTAValue.getBooleanValue(), (Composite)this.group);
            this.checkState();
        }
    }

    private ComboFieldEditor createDefaultTAPreferenceWidget() {
        String[] supportedTargetApplication = TargetApplicationExtensionManager.getSupportedTargetApplication();
        String[][] supportedTAForComboBox = new String[supportedTargetApplication.length][2];
        int i = 0;
        while (i < supportedTargetApplication.length) {
            supportedTAForComboBox[i][0] = supportedTargetApplication[i];
            supportedTAForComboBox[i][1] = supportedTargetApplication[i];
            ++i;
        }
        ComboFieldEditor result = new ComboFieldEditor("DefaultViewpointTA", "Default Target application", supportedTAForComboBox, this.getFieldEditorParent());
        Label labelControl = result.getLabelControl(this.getFieldEditorParent());
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        labelControl.setLayoutData((Object)gd);
        return result;
    }

    private void createGroup() {
        this.group = new Group(this.getFieldEditorParent(), 0);
        this.group.setText(" Root project name setting ");
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        gd.verticalIndent = 5;
        GridLayout layout = new GridLayout();
        this.group.setLayoutData((Object)gd);
        this.group.setLayout((Layout)layout);
    }

    private void handlePreferencesDefaultValues() {
        String defaultTAPrefValue;
        Boolean useTAPrefValue = this.store.getBoolean("UseTAViewpointRootProjectName");
        this.rpnField.setEnabled(useTAPrefValue == false, (Composite)this.group);
        String rpnPrefValue = this.store.getString("ViewpointRootProjectName");
        if (rpnPrefValue == null || rpnPrefValue.trim().length() == 0) {
            this.store.setDefault("ViewpointRootProjectName", "org.polarsys.kitalpha.viewpoint");
        }
        if ((defaultTAPrefValue = this.store.getString("DefaultViewpointTA")) == null || defaultTAPrefValue.trim().length() == 0) {
            this.store.setDefault("DefaultViewpointTA", "EMF");
        }
    }
}

