/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.polarsys.capella.core.ui.search.Activator;
import org.polarsys.capella.core.ui.search.CapellaSearchSettings;
import org.polarsys.capella.core.ui.search.searchfor.SearchForItemCache;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForAttributeItem;
import org.polarsys.capella.core.ui.search.searchfor.item.SearchForClassItem;

public abstract class AbstractCapellaHistory {
    protected static final int HISTORY_SIZE = 5;
    protected static final String SECTION_SEARCH = "org.polarsys.capella.core.ui.search.page.replace";
    protected static final String SECTION_SEARCH_REPLACE_PATTERN = "replace.pattern";
    protected static final String SECTION_HISTORY_PREFIX = "history.replace";
    protected static final String SECTION_HISTORY_COUNT = "history.count.replace";
    protected static final String SECTION_SEARCH_ATTRIBUTE_PREFIX = "attribute.replace";
    protected static final String SECTION_SEARCH_ATTRIBUTE_COUNT = "attribute.count.replace";
    protected static final String SECTION_SEARCH_METACLASS_PREFIX = "metaclass.replace";
    protected static final String SECTION_SEARCH_METACLASS_COUNT = "metaclass.count.replace";
    protected static final String SECTION_SEARCH_PROJECT_PREFIX = "project.replace";
    protected static final String SECTION_SEARCH_PROJECT_COUNT = "project.count.replace";

    public List<CapellaSearchSettings> getAllSearchSettings() {
        ArrayList<CapellaSearchSettings> capellaSearchSettingsInHistory = new ArrayList<CapellaSearchSettings>();
        IDialogSettings capellaSearchSection = this.getDialogSettingsForCapellaSearch();
        try {
            int currentHistoryCount = capellaSearchSection.getInt(SECTION_HISTORY_COUNT);
            int i = currentHistoryCount - 1;
            while (i >= 0) {
                capellaSearchSettingsInHistory.add(this.createSearchSettingsFromHistoryIndex(i));
                --i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return capellaSearchSettingsInHistory;
    }

    private CapellaSearchSettings createSearchSettingsFromHistoryIndex(int historyIndex) {
        IDialogSettings searchHistorySection = this.getDialogSettingsForHistoryIndex(historyIndex);
        CapellaSearchSettings searchSettings = new CapellaSearchSettings();
        if (searchHistorySection != null) {
            this.setSearchSettings(searchSettings, searchHistorySection);
            try {
                int projectsCount = searchHistorySection.getInt(SECTION_SEARCH_PROJECT_COUNT);
                int i = 0;
                while (i < projectsCount) {
                    searchSettings.addObjectToSearch(searchHistorySection.get(SECTION_SEARCH_PROJECT_PREFIX + i));
                    ++i;
                }
                int fieldsCount = searchHistorySection.getInt(SECTION_SEARCH_ATTRIBUTE_COUNT);
                int i2 = 0;
                while (i2 < fieldsCount) {
                    String searchFieldText = searchHistorySection.get(SECTION_SEARCH_ATTRIBUTE_PREFIX + i2);
                    Object attribute = SearchForItemCache.getInstance().getAttribute(searchFieldText);
                    if (attribute != null) {
                        searchSettings.getSearchAttributeItems().add(attribute);
                    }
                    ++i2;
                }
                int metaFieldsCount = searchHistorySection.getInt(SECTION_SEARCH_METACLASS_COUNT);
                int i3 = 0;
                while (i3 < metaFieldsCount) {
                    String searchFieldText = searchHistorySection.get(SECTION_SEARCH_METACLASS_PREFIX + i3);
                    Object metaclass = SearchForItemCache.getInstance().getClassItem(searchFieldText);
                    if (metaclass != null) {
                        searchSettings.getSearchClassItems().add(metaclass);
                    } else {
                        searchSettings.getSearchClassItems().add(searchFieldText);
                    }
                    ++i3;
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return searchSettings;
    }

    protected abstract void setSearchSettings(CapellaSearchSettings var1, IDialogSettings var2);

    public void appendSearchSettings(CapellaSearchSettings capellaSearchSettings) {
        IDialogSettings capellaSearchSection = this.getDialogSettingsForCapellaSearch();
        int historyIndex = this.getHistoryIndex(capellaSearchSettings);
        if (historyIndex == -1) {
            int historyPointToAppend = 0;
            try {
                int currentHistoryCount = capellaSearchSection.getInt(SECTION_HISTORY_COUNT);
                if (currentHistoryCount == 5) {
                    int i = 0;
                    while (i < currentHistoryCount - 1) {
                        this.saveSearchSettingsToHistoryPoint(this.createSearchSettingsFromHistoryIndex(i + 1), i);
                        ++i;
                    }
                    historyPointToAppend = 4;
                } else {
                    historyPointToAppend = currentHistoryCount;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.saveSearchSettingsToHistoryPoint(capellaSearchSettings, historyPointToAppend);
            capellaSearchSection.put(SECTION_HISTORY_COUNT, historyPointToAppend + 1);
        }
    }

    private IDialogSettings getDialogSettingsForCapellaSearch() {
        IDialogSettings dialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection(SECTION_SEARCH);
        if (section == null) {
            section = dialogSettings.addNewSection(SECTION_SEARCH);
        }
        return section;
    }

    private IDialogSettings getDialogSettingsForHistoryIndex(int historyIndex) {
        IDialogSettings capellaSearch = this.getDialogSettingsForCapellaSearch();
        IDialogSettings searchSectionAtHistoryPoint = capellaSearch.getSection(SECTION_HISTORY_PREFIX + historyIndex);
        if (searchSectionAtHistoryPoint == null) {
            searchSectionAtHistoryPoint = capellaSearch.addNewSection(SECTION_HISTORY_PREFIX + historyIndex);
        }
        return searchSectionAtHistoryPoint;
    }

    private void saveSearchSettingsToHistoryPoint(CapellaSearchSettings capellaSearchSettings, int historyIndex) {
        IDialogSettings searchHistorySection = this.getDialogSettingsForHistoryIndex(historyIndex);
        if (searchHistorySection != null) {
            this.setSearchHistorySettings(capellaSearchSettings, searchHistorySection);
            int projectsCount = 0;
            for (Object project : capellaSearchSettings.getObjectsToSearch()) {
                if (!(project instanceof IProject)) continue;
                searchHistorySection.put(SECTION_SEARCH_PROJECT_PREFIX + projectsCount, ((IProject)project).getName());
                ++projectsCount;
            }
            searchHistorySection.put(SECTION_SEARCH_PROJECT_COUNT, projectsCount);
            int attrFieldsCount = 0;
            for (Object searchAttribute : capellaSearchSettings.getSearchAttributeItems()) {
                SearchForAttributeItem attributeItem = (SearchForAttributeItem)searchAttribute;
                searchHistorySection.put(SECTION_SEARCH_ATTRIBUTE_PREFIX + attrFieldsCount, attributeItem.getText());
                ++attrFieldsCount;
            }
            searchHistorySection.put(SECTION_SEARCH_ATTRIBUTE_COUNT, attrFieldsCount);
            int clsFieldsCount = 0;
            for (Object searchMetaClasses : capellaSearchSettings.getSearchClassItems()) {
                if (searchMetaClasses instanceof SearchForClassItem) {
                    SearchForClassItem classItem = (SearchForClassItem)searchMetaClasses;
                    searchHistorySection.put(SECTION_SEARCH_METACLASS_PREFIX + clsFieldsCount, classItem.getUniqueID());
                    ++clsFieldsCount;
                    continue;
                }
                searchHistorySection.put(SECTION_SEARCH_METACLASS_PREFIX + clsFieldsCount, searchMetaClasses.toString());
                ++clsFieldsCount;
            }
            searchHistorySection.put(SECTION_SEARCH_METACLASS_COUNT, clsFieldsCount);
        }
    }

    protected abstract void setSearchHistorySettings(CapellaSearchSettings var1, IDialogSettings var2);

    private int getHistoryIndex(CapellaSearchSettings capellaSearchSettings) {
        IDialogSettings capellaSearchSection = this.getDialogSettingsForCapellaSearch();
        try {
            int currentHistoryCount = capellaSearchSection.getInt(SECTION_HISTORY_COUNT);
            int i = 0;
            while (i < currentHistoryCount) {
                CapellaSearchSettings searchSettingsInHistory = this.createSearchSettingsFromHistoryIndex(i);
                if (searchSettingsInHistory.equals(capellaSearchSettings)) {
                    return i;
                }
                ++i;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return -1;
    }
}

