/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.search.match;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.search.ui.text.Match;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.ui.search.match.SearchMatchChild;

public class SearchMatch
extends Match {
    private static final Set<String> ATTRIBUTE_NAMES_TO_FORMAT = new HashSet<String>();
    protected String originalText;
    protected String displayText;
    protected IProject project;
    protected Object attribute;
    protected List<SearchMatchChild> children;

    static {
        ATTRIBUTE_NAMES_TO_FORMAT.add("description");
        ATTRIBUTE_NAMES_TO_FORMAT.add("documentation");
    }

    public SearchMatch(Object inputObject, String originalText, IProject project) {
        super(inputObject, -1, -1);
        this.project = project;
        this.originalText = originalText;
        this.children = new ArrayList<SearchMatchChild>();
    }

    public SearchMatch(Object inputObject, String originalText, IProject project, Object attribute) {
        this(inputObject, originalText, project);
        this.attribute = attribute;
    }

    public String getOriginalText() {
        return this.originalText;
    }

    public void setOriginalText(String text) {
        this.originalText = text;
        this.displayText = this.computeDisplayedText(text);
    }

    public String getDisplayText() {
        if (this.displayText == null) {
            this.displayText = this.computeDisplayedText(this.originalText);
        }
        return this.displayText;
    }

    public IProject getProject() {
        return this.project;
    }

    public List<SearchMatchChild> getChildren() {
        return this.children;
    }

    public Object getAttribute() {
        return this.attribute;
    }

    public boolean replace(Pattern searchPattern, String replacement) {
        return this.getChildren().isEmpty() ? this.replaceLocally(searchPattern, replacement) : this.replaceInChildren(searchPattern, replacement);
    }

    protected boolean replaceLocally(Pattern searchPattern, String replacement) {
        Object element;
        Object eAttribute = this.getAttribute();
        if (eAttribute != null && (element = this.getElement()) instanceof EObject) {
            String oldLine = this.getOriginalText();
            String newContent = searchPattern.matcher(oldLine).replaceAll(replacement);
            EObject eObject = (EObject)element;
            TransactionalEditingDomain domain = TransactionHelper.getEditingDomain((EObject)eObject);
            Command setCommand = SetCommand.create((EditingDomain)domain, (Object)eObject, (Object)eAttribute, (Object)newContent);
            domain.getCommandStack().execute(setCommand);
            this.setOriginalText(newContent);
            return true;
        }
        return false;
    }

    protected boolean replaceInChildren(Pattern searchPattern, String replacement) {
        boolean replaced = false;
        for (SearchMatchChild child : this.getChildren()) {
            replaced |= child.replace(searchPattern, replacement);
        }
        return replaced;
    }

    protected String computeDisplayedText(String originalText) {
        if (originalText != null && this.shouldSanitizeHTML()) {
            return StringEscapeUtils.unescapeHtml((String)originalText).replaceAll("\\<[^>]*>", "").trim();
        }
        return originalText;
    }

    protected boolean shouldSanitizeHTML() {
        Object lAttribute = this.getAttribute();
        if (lAttribute instanceof EAttribute) {
            EAttribute eAttribute = (EAttribute)lAttribute;
            return ATTRIBUTE_NAMES_TO_FORMAT.contains(eAttribute.getName());
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.attribute, this.children, this.displayText, this.originalText, this.project);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SearchMatch)) {
            return false;
        }
        SearchMatch other = (SearchMatch)((Object)obj);
        return Objects.equals(this.getElement(), other.getElement()) && Objects.equals(this.attribute, other.attribute) && Objects.equals(this.children, other.children) && Objects.equals(this.originalText, other.originalText) && Objects.equals(this.project, other.project);
    }
}

