/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.TreeSearch;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.polarsys.capella.core.model.links.helpers.LinkInfo;
import org.polarsys.capella.core.ui.fastlinker.view.FilteringGridData;
import org.polarsys.capella.core.ui.fastlinker.view.FilteringGridLayout;
import org.polarsys.capella.core.ui.fastlinker.view.IDoubleClickListener;
import org.polarsys.capella.core.ui.fastlinker.view.providers.FastLinkerLabelProvider;

public class FastLinkerFigureCanvas
extends FigureCanvas
implements ISelectionProvider {
    protected static final TreeSearch LABEL_FILTER = new TreeSearch(){

        public boolean accept(IFigure figure) {
            return figure instanceof Label;
        }

        public boolean prune(IFigure figure) {
            return false;
        }
    };
    protected final List<IDoubleClickListener> doubleClickListeners;
    protected final Figure fastLinkerFigure;
    protected final Map<IFigure, Collection> figureToModelElement = new HashMap<IFigure, Collection>();
    protected final FastLinkerLabelProvider capellaElementLabelProvider;
    protected IFigure selectedFigure;
    protected final List<ISelectionChangedListener> selectionListeners = new ArrayList<ISelectionChangedListener>();
    protected final SelectionDragManager sharedDragManager;

    public FastLinkerFigureCanvas(Composite parent, int style) {
        super(parent, style);
        this.doubleClickListeners = new ArrayList<IDoubleClickListener>();
        this.capellaElementLabelProvider = new FastLinkerLabelProvider();
        this.fastLinkerFigure = new Figure();
        this.setContents((IFigure)this.fastLinkerFigure);
        this.sharedDragManager = new SelectionDragManager();
        this.fastLinkerFigure.addMouseListener((MouseListener)this.sharedDragManager);
        this.fastLinkerFigure.addMouseMotionListener((MouseMotionListener)this.sharedDragManager);
        this.setBackground(Display.getCurrent().getSystemColor(1));
        this.setScrollBarVisibility(FigureCanvas.AUTOMATIC);
    }

    public void addDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.add(listener);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    protected IFigure createConnection(IFigure sourceFigure, IFigure targetFigure, LinkInfo.LinkStyle linkGraphicalRepresentation) {
        PolylineConnection connection = new PolylineConnection();
        connection.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor(sourceFigure));
        connection.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor(targetFigure));
        connection.setAntialias(1);
        if (LinkInfo.LinkStyle.LINE_DASHED == linkGraphicalRepresentation) {
            connection.setLineStyle(6);
            connection.setLineDash(new float[]{4.0f, 4.0f});
        } else {
            connection.setLineStyle(1);
        }
        if (LinkInfo.LinkStyle.LINE_SOLID_WITH_EMPTY_ARROW == linkGraphicalRepresentation) {
            PolygonDecoration pd = new PolygonDecoration();
            pd.setBackgroundColor(Display.getCurrent().getSystemColor(1));
            connection.setTargetDecoration((RotatableDecoration)pd);
        } else if (LinkInfo.LinkStyle.LINE_SOLID_WITH_FILLED_ARROW == linkGraphicalRepresentation) {
            PolygonDecoration pd = new PolygonDecoration();
            connection.setTargetDecoration((RotatableDecoration)pd);
        }
        return connection;
    }

    protected Label createModelElementFigure(Collection modelElement, boolean displayInBold) {
        Label modelElementFigure = new Label(this.capellaElementLabelProvider.getText(modelElement), this.capellaElementLabelProvider.getImage(modelElement));
        if (displayInBold) {
            Font boldFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
            modelElementFigure.setFont(boldFont);
        }
        this.figureToModelElement.put((IFigure)modelElementFigure, modelElement);
        return modelElementFigure;
    }

    public void fillFigure(Collection firstElement, Collection secondElement, Collection pinnedElement, LinkInfo linkRepresentation) {
        this.figureToModelElement.clear();
        this.fastLinkerFigure.removeAll();
        this.selectedFigure = null;
        this.fireSelectionChanged();
        this.fastLinkerFigure.setLayoutManager((LayoutManager)new FilteringGridLayout(1, false));
        Label secondElementFigure = null;
        if (secondElement != null) {
            secondElementFigure = this.createModelElementFigure(secondElement, secondElement == pinnedElement);
            this.fastLinkerFigure.add((IFigure)secondElementFigure, (Object)new FilteringGridData(0x1000000, 0x1000000, true, true));
        }
        Label firstElementFigure = null;
        if (firstElement != null) {
            firstElementFigure = this.createModelElementFigure(firstElement, firstElement == pinnedElement);
            this.fastLinkerFigure.add((IFigure)firstElementFigure, (Object)new FilteringGridData(0x1000000, 0x1000000, true, true));
        }
        if (linkRepresentation != null) {
            IFigure connection = null;
            if (firstElement != null && firstElement.contains(linkRepresentation._sourceElement) && secondElement != null && secondElement.contains(linkRepresentation._targetElement)) {
                connection = this.createConnection((IFigure)firstElementFigure, (IFigure)secondElementFigure, linkRepresentation._linkStyle);
            } else if (secondElement != null && secondElement.contains(linkRepresentation._sourceElement) && firstElement != null && firstElement.contains(linkRepresentation._targetElement)) {
                connection = this.createConnection((IFigure)secondElementFigure, (IFigure)firstElementFigure, linkRepresentation._linkStyle);
            }
            if (connection != null) {
                this.fastLinkerFigure.add(connection);
            }
        }
    }

    protected void fireDoubleClick() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (IDoubleClickListener listener : this.doubleClickListeners) {
            listener.doubleClick(event);
        }
    }

    protected void fireSelectionChanged() {
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener listener : this.selectionListeners) {
            listener.selectionChanged(event);
        }
    }

    public ISelection getSelection() {
        if (this.selectedFigure == null || this.figureToModelElement.get(this.selectedFigure) == null) {
            return StructuredSelection.EMPTY;
        }
        return new StructuredSelection((Object)this.figureToModelElement.get(this.selectedFigure));
    }

    public void removeDoubleClickListener(IDoubleClickListener listener) {
        this.doubleClickListeners.remove(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    protected void switchToXYLayout(IFigure figure) {
        figure.setLayoutManager((LayoutManager)new XYLayout());
        List children = figure.getChildren();
        for (Object child : children) {
            IFigure childFigure = (IFigure)child;
            figure.setConstraint(childFigure, (Object)childFigure.getBounds());
        }
    }

    protected class SelectionDragManager
    extends MouseMotionListener.Stub
    implements MouseListener {
        private IFigure draggedFigure;
        private Point lastFigureLocation;

        protected SelectionDragManager() {
        }

        public void mouseDoubleClicked(MouseEvent me) {
            FastLinkerFigureCanvas.this.fireDoubleClick();
        }

        public void mouseDragged(MouseEvent e) {
            if (this.draggedFigure == null) {
                return;
            }
            Point newFigureLocation = e.getLocation();
            Dimension delta = newFigureLocation.getDifference(this.lastFigureLocation);
            this.lastFigureLocation = newFigureLocation;
            if (FastLinkerFigureCanvas.this.fastLinkerFigure.getLayoutManager() instanceof FilteringGridLayout) {
                FastLinkerFigureCanvas.this.switchToXYLayout((IFigure)FastLinkerFigureCanvas.this.fastLinkerFigure);
            }
            Rectangle newBounds = this.draggedFigure.getBounds().getTranslated(delta.width, delta.height);
            if (newBounds.x > 0 && newBounds.y > 0) {
                this.draggedFigure.getParent().setConstraint(this.draggedFigure, (Object)newBounds);
            }
        }

        public void mousePressed(MouseEvent e) {
            this.lastFigureLocation = e.getLocation();
            e.consume();
            IFigure newSelectedFigure = FastLinkerFigureCanvas.this.fastLinkerFigure.findFigureAt(e.x, e.y, LABEL_FILTER);
            if (FastLinkerFigureCanvas.this.selectedFigure != newSelectedFigure) {
                if (FastLinkerFigureCanvas.this.selectedFigure != null) {
                    FastLinkerFigureCanvas.this.selectedFigure.setBorder(null);
                }
                if (newSelectedFigure != null) {
                    newSelectedFigure.setBorder((Border)new LineBorder());
                    if (FastLinkerFigureCanvas.this.fastLinkerFigure.getLayoutManager().getConstraint(newSelectedFigure) instanceof Rectangle) {
                        ((Rectangle)FastLinkerFigureCanvas.this.fastLinkerFigure.getLayoutManager().getConstraint(newSelectedFigure)).setSize(newSelectedFigure.getPreferredSize());
                    }
                }
                FastLinkerFigureCanvas.this.selectedFigure = newSelectedFigure;
                FastLinkerFigureCanvas.this.fireSelectionChanged();
            }
            if (newSelectedFigure != null) {
                this.draggedFigure = newSelectedFigure;
            }
        }

        public void mouseReleased(MouseEvent e) {
            this.draggedFigure = null;
        }
    }
}

