/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.fastlinker.view;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.model.links.helpers.commands.AbstractCreateLinksCommand;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerActivator;
import org.polarsys.capella.core.ui.fastlinker.FastLinkerState;
import org.polarsys.capella.core.ui.fastlinker.view.FastLinkerFigureCanvas;
import org.polarsys.capella.core.ui.fastlinker.view.Messages;
import org.polarsys.capella.core.ui.fastlinker.view.providers.FastLinkerLabelProvider;
import org.polarsys.capella.core.ui.properties.CapellaTabbedPropertySheetPage;
import org.polarsys.capella.core.ui.properties.CapellaUIPropertiesPlugin;

public class FastLinkerView
extends ViewPart
implements ITabbedPropertySheetPageContributor,
IEditingDomainProvider {
    public static final String VIEW_ID = "org.polarsys.capella.core.ui.fastlinker.view";
    protected Action clearFastLinkerAction;
    protected FastLinkerFigureCanvas fastLinkerFigureCanvas;
    protected FastLinkerLabelProvider fastLinkerLabelProvider;
    protected Action pinElementAction;
    protected CapellaTabbedPropertySheetPage propertySheetPage;

    public AbstractCreateLinksCommand chooseCommandToExecute(List<AbstractCreateLinksCommand> firstToSecondCommands, List<AbstractCreateLinksCommand> secondToFirstCommands) {
        final AbstractCreateLinksCommand[] selectedCommand = new AbstractCreateLinksCommand[1];
        SelectionAdapter menuItemSelectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!(e.getSource() instanceof MenuItem)) {
                    return;
                }
                Object data = ((MenuItem)e.getSource()).getData();
                if (data instanceof AbstractCreateLinksCommand) {
                    selectedCommand[0] = (AbstractCreateLinksCommand)data;
                }
            }
        };
        String firstElementName = this.fastLinkerLabelProvider.getText(FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState().getFirstElement());
        String secondElementName = this.fastLinkerLabelProvider.getText(FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState().getSecondElement());
        Menu myMenu = new Menu((Control)this.fastLinkerFigureCanvas);
        if (!firstToSecondCommands.isEmpty() && !secondToFirstCommands.isEmpty()) {
            Menu firstToSecondSubMenu = new Menu(myMenu);
            MenuItem firstToSecondSubMenuItem = new MenuItem(myMenu, 64);
            firstToSecondSubMenuItem.setText(String.valueOf(firstElementName) + " -> " + secondElementName);
            firstToSecondSubMenuItem.setMenu(firstToSecondSubMenu);
            this.fillMenuWithCommands(firstToSecondSubMenu, firstToSecondCommands, (SelectionListener)menuItemSelectionAdapter);
            Menu secondToFirstSubMenu = new Menu(myMenu);
            MenuItem secondToFirstSubMenuItem = new MenuItem(myMenu, 64);
            secondToFirstSubMenuItem.setText(String.valueOf(secondElementName) + " -> " + firstElementName);
            secondToFirstSubMenuItem.setMenu(secondToFirstSubMenu);
            this.fillMenuWithCommands(secondToFirstSubMenu, secondToFirstCommands, (SelectionListener)menuItemSelectionAdapter);
        } else if (!firstToSecondCommands.isEmpty()) {
            this.fillMenuWithCommands(myMenu, firstToSecondCommands, (SelectionListener)menuItemSelectionAdapter);
        } else if (!secondToFirstCommands.isEmpty()) {
            this.fillMenuWithCommands(myMenu, secondToFirstCommands, (SelectionListener)menuItemSelectionAdapter);
        }
        new MenuItem(myMenu, 2);
        MenuItem mi1 = new MenuItem(myMenu, 0);
        mi1.setText(Messages.FastLinkerView_MenuItem_Cancel_Text);
        Point fastLinkerSize = this.fastLinkerFigureCanvas.getSize();
        myMenu.setLocation(this.fastLinkerFigureCanvas.toDisplay(fastLinkerSize.x / 2, fastLinkerSize.y / 2));
        myMenu.setVisible(true);
        while (!myMenu.isDisposed() && myMenu.isVisible()) {
            if (myMenu.getDisplay().readAndDispatch()) continue;
            myMenu.getDisplay().sleep();
        }
        return selectedCommand[0];
    }

    protected void createActions() {
        IToolBarManager toolBarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.clearFastLinkerAction = this.createClearAction();
        toolBarManager.add((IAction)this.clearFastLinkerAction);
        this.pinElementAction = this.createPinElementAction();
        toolBarManager.add((IAction)this.pinElementAction);
    }

    protected Action createClearAction() {
        Action action = new Action(Messages.FastLinkerView_Action_ClearView_Text){

            public void run() {
                FastLinkerActivator.getDefault().getFastLinkerManager().clearFastLinker();
            }
        };
        action.setToolTipText(Messages.FastLinkerView_Action_ClearView_Text);
        action.setImageDescriptor(FastLinkerActivator.getDefault().getImageRegistry().getDescriptor("IMG_CLEAR"));
        return action;
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.fastLinkerLabelProvider = new FastLinkerLabelProvider();
        this.fastLinkerFigureCanvas = new FastLinkerFigureCanvas(parent, 0);
        this.fastLinkerFigureCanvas.addSelectionChangedListener(event -> {
            this.refreshPropertyPage(event.getSelectionProvider());
            this.updateStatusBar(this.getFirstModelElementFromSelection(event.getSelection()));
        });
        this.fastLinkerFigureCanvas.addDoubleClickListener(event -> {
            Collection doubleClickedModelElement = this.getFirstModelElementFromSelection(event.getSelection());
            if (doubleClickedModelElement != null && !doubleClickedModelElement.isEmpty()) {
                CapellaUIPropertiesPlugin.getDefault().openWizard((EObject)doubleClickedModelElement.iterator().next());
            }
        });
        this.createActions();
        this.initializeContextMenu();
        this.getViewSite().setSelectionProvider((ISelectionProvider)this.fastLinkerFigureCanvas);
        int operations = 2;
        DropTarget target = new DropTarget((Control)this.fastLinkerFigureCanvas, operations);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void dragEnter(DropTargetEvent event) {
                Collection draggedElement = FastLinkerView.this.getFirstModelElementFromSelection(LocalSelectionTransfer.getTransfer().getSelection());
                if (!FastLinkerActivator.getDefault().getFastLinkerManager().acceptElementInFastLinker(draggedElement)) {
                    event.detail = 0;
                }
            }

            public void drop(DropTargetEvent event) {
                Collection draggedElement = FastLinkerView.this.getFirstModelElementFromSelection(LocalSelectionTransfer.getTransfer().getSelection());
                FastLinkerActivator.getDefault().getFastLinkerManager().putElementInFastLinker(draggedElement);
            }
        });
        this.update();
    }

    protected Action createPinElementAction() {
        Action action = new Action(Messages.FastLinkerView_Action_PinUnpinSelectedElement_Text, 4){

            public void run() {
                Collection selectedModelElement = FastLinkerView.this.getFirstModelElementFromSelection(FastLinkerView.this.fastLinkerFigureCanvas.getSelection());
                FastLinkerActivator.getDefault().getFastLinkerManager().pinModelElement(selectedModelElement);
            }
        };
        action.setMenuCreator((IMenuCreator)new PinDropDownMenuCreator());
        action.setToolTipText(Messages.FastLinkerView_Action_PinUnpinSelectedElement_Text);
        action.setImageDescriptor(FastLinkerActivator.getDefault().getImageRegistry().getDescriptor("IMG_PIN"));
        return action;
    }

    protected void fillMenuWithCommands(Menu menu, List<AbstractCreateLinksCommand> commands, SelectionListener menuItemSelectionListener) {
        for (Command command : commands) {
            MenuItem mi = new MenuItem(menu, 0);
            mi.setText(command.getLabel());
            mi.setData((Object)command);
            mi.addSelectionListener(menuItemSelectionListener);
        }
    }

    public Object getAdapter(Class adapter) {
        if (IPropertySheetPage.class.equals((Object)adapter)) {
            return this.getPropertySheetPage();
        }
        return super.getAdapter(adapter);
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    public EditingDomain getEditingDomain() {
        Object elt;
        ISelection selection = this.fastLinkerFigureCanvas.getSelection();
        if (selection instanceof IStructuredSelection && (elt = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            return TransactionHelper.getEditingDomain((EObject)((EObject)elt));
        }
        return null;
    }

    protected Collection getFirstModelElementFromSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        List firstElements = ((IStructuredSelection)selection).toList();
        for (Object firstElement : firstElements) {
            if (firstElement instanceof ModelElement) continue;
            return null;
        }
        return firstElements;
    }

    protected TabbedPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new CapellaTabbedPropertySheetPage(this){

                public void dispose() {
                    super.dispose();
                    FastLinkerView.this.propertySheetPage = null;
                }

                public void init(IPageSite pageSite) {
                    super.init(pageSite);
                    pageSite.setSelectionProvider(FastLinkerView.this.getViewSite().getSelectionProvider());
                }
            };
        }
        return this.propertySheetPage;
    }

    private void initializeContextMenu() {
        MenuManager menuManager = new MenuManager("FastLinkerPopupMenu", VIEW_ID);
        menuManager.setRemoveAllWhenShown(true);
        Menu currentMenu = menuManager.createContextMenu((Control)this.fastLinkerFigureCanvas);
        this.fastLinkerFigureCanvas.setMenu(currentMenu);
        this.getSite().registerContextMenu(VIEW_ID, menuManager, (ISelectionProvider)this.fastLinkerFigureCanvas);
    }

    protected void refreshPropertyPage(ISelectionProvider selectionProvider) {
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        if (this.propertySheetPage != null && !this.propertySheetPage.getControl().isDisposed()) {
            ISelectionProvider pageSelectionProvider = this.propertySheetPage.getSite().getSelectionProvider();
            if (pageSelectionProvider == null || pageSelectionProvider != selectionProvider) {
                this.propertySheetPage.getSite().setSelectionProvider(selectionProvider);
            }
            this.propertySheetPage.selectionChanged((IWorkbenchPart)this, (ISelection)selection);
        }
    }

    public void setFocus() {
        this.fastLinkerFigureCanvas.setFocus();
    }

    public void update() {
        FastLinkerState currentState = FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState();
        this.fastLinkerFigureCanvas.fillFigure(currentState.getFirstElement(), currentState.getSecondElement(), currentState.getPinnedElement(), currentState.getLinkCreated());
        this.pinElementAction.setEnabled(currentState.getFirstElement() != null || currentState.getSecondElement() != null);
        this.clearFastLinkerAction.setEnabled(currentState.getFirstElement() != null || currentState.getSecondElement() != null);
    }

    public void updateStatusBar(Object elementToDisplay) {
        Image elementImage = this.fastLinkerLabelProvider.getImage(elementToDisplay);
        String elementDescription = this.fastLinkerLabelProvider.getDescription(elementToDisplay);
        this.getViewSite().getActionBars().getStatusLineManager().setMessage(elementImage, elementDescription);
    }

    public void dispose() {
        super.dispose();
        this.fastLinkerLabelProvider.dispose();
    }

    protected class PinDropDownMenuCreator
    implements IMenuCreator {
        private Menu menu;

        protected PinDropDownMenuCreator() {
        }

        protected MenuItem createPinMenuItem(Menu parentMenu, final Collection modelElement, Collection<EObject> pinnedElement) {
            MenuItem menuItem = new MenuItem(parentMenu, 32);
            menuItem.setImage(FastLinkerView.this.fastLinkerLabelProvider.getImage(modelElement));
            menuItem.setText(FastLinkerView.this.fastLinkerLabelProvider.getText(modelElement));
            menuItem.setSelection(modelElement == pinnedElement);
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FastLinkerActivator.getDefault().getFastLinkerManager().pinModelElement(modelElement);
                }
            });
            return menuItem;
        }

        public void dispose() {
            if (this.menu != null) {
                this.menu.dispose();
            }
        }

        public Menu getMenu(Control parent) {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = new Menu(parent);
            FastLinkerState state = FastLinkerActivator.getDefault().getFastLinkerManager().getCurrentState();
            if (state.getSecondElement() != null) {
                this.createPinMenuItem(this.menu, state.getSecondElement(), state.getPinnedElement());
            }
            if (state.getFirstElement() != null) {
                this.createPinMenuItem(this.menu, state.getFirstElement(), state.getPinnedElement());
            }
            return this.menu;
        }

        public Menu getMenu(Menu parent) {
            return null;
        }
    }
}

