/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.config.IComparisonConfiguration;
import org.eclipse.emf.diffmerge.generic.api.config.IComparisonConfigurator;
import org.eclipse.emf.diffmerge.generic.api.config.IConfigurablePolicy;
import org.eclipse.emf.diffmerge.generic.api.scopes.IEditableTreeDataScope;
import org.eclipse.emf.diffmerge.generic.gdiffdata.GComparison;
import org.eclipse.emf.diffmerge.impl.policies.ComparisonConfigurator;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMergePolicy;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.ComparisonConfiguration;
import org.eclipse.emf.diffmerge.ui.specification.ext.ConfigureComparisonDialog;
import org.eclipse.emf.diffmerge.ui.specification.ext.DefaultComparisonMethod;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ConfigurableComparisonMethod
extends DefaultComparisonMethod<EObject>
implements IComparisonConfigurator.Provider {
    public static final IComparisonConfigurator CONFIGURATOR_DATA_TRANSFER = new ComparisonConfigurator(Messages.ConfigurableComparisonMethod_Usage_Transfer, Messages.ConfigurableComparisonMethod_Usage_Transfer_Tooltip, Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE, ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS), Arrays.asList(ConfigurableMatchPolicy.CRITERION_STRUCTURE_ROOTS, ConfigurableMatchPolicy.CRITERION_SEMANTICS_DEFAULTCONTENTS));
    public static final IComparisonConfigurator CONFIGURATOR_VERSIONS = new ComparisonConfigurator(Messages.ConfigurableComparisonMethod_Usage_Versions, Messages.ConfigurableComparisonMethod_Usage_Versions_Tooltip, Arrays.asList(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID), Collections.emptySet());
    protected static ComparisonConfiguration __lastComparisonConfiguration = null;
    protected static Class<? extends ConfigurableComparisonMethod> __lastComparisonMethodType = null;
    protected final List<IComparisonConfigurator> _configurators = new ArrayList<IComparisonConfigurator>(this.createConfigurators());

    public ConfigurableComparisonMethod(IModelScopeDefinition leftScopeDef_p, IModelScopeDefinition rightScopeDef_p, IModelScopeDefinition ancestorScopeDef_p, IComparisonMethodFactory<EObject> factory_p) {
        super(leftScopeDef_p, rightScopeDef_p, ancestorScopeDef_p, factory_p);
        this.initialize();
    }

    @Override
    public void configure() {
        ComparisonConfiguration data;
        int confirmed;
        Shell shell = this.getShell();
        if (shell != null && (confirmed = new ConfigureComparisonDialog(shell, data = new ComparisonConfiguration(this)).open()) == 0) {
            this.configurationConfirmed(data);
        }
    }

    protected void configurationConfirmed(ComparisonConfiguration data_p) {
        __lastComparisonConfiguration = data_p;
        __lastComparisonMethodType = this.getClass();
        this.update(data_p);
    }

    @Override
    public GComparison<EObject, ?, ?> createComparison(IEditableTreeDataScope<EObject> targetScope_p, IEditableTreeDataScope<EObject> referenceScope_p, IEditableTreeDataScope<EObject> ancestorScope_p) {
        return new EComparisonImpl(targetScope_p, referenceScope_p, ancestorScope_p);
    }

    protected List<IComparisonConfigurator> createConfigurators() {
        LinkedList<IComparisonConfigurator> result = new LinkedList<IComparisonConfigurator>();
        result.add(CONFIGURATOR_VERSIONS);
        result.add(CONFIGURATOR_DATA_TRANSFER);
        return result;
    }

    @Override
    protected IDiffPolicy<EObject> createDiffPolicy() {
        return new ConfigurableDiffPolicy();
    }

    @Override
    protected IMatchPolicy<EObject> createMatchPolicy() {
        return new ConfigurableMatchPolicy();
    }

    @Override
    protected IMergePolicy<EObject> createMergePolicy() {
        return new ConfigurableMergePolicy();
    }

    public List<IComparisonConfigurator> getConfigurators() {
        return Collections.unmodifiableList(this._configurators);
    }

    public IComparisonConfigurator getDefaultConfigurator() {
        return CONFIGURATOR_VERSIONS;
    }

    public Shell getShell() {
        Shell result;
        try {
            result = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        }
        catch (Exception e) {
            result = null;
        }
        return result;
    }

    protected void initialize() {
        if (__lastComparisonMethodType != null && __lastComparisonMethodType.isAssignableFrom(this.getClass())) {
            this.update(__lastComparisonConfiguration);
        } else {
            IComparisonConfigurator defaultConfigurator = this.getDefaultConfigurator();
            if (defaultConfigurator != null) {
                defaultConfigurator.apply((IComparisonConfiguration)this);
            }
        }
    }

    @Override
    public boolean isConfigurable() {
        return true;
    }

    protected void update(ComparisonConfiguration data_p) {
        if (data_p == null) {
            return;
        }
        IMatchPolicy originalMatchPolicy = this.getMatchPolicy();
        ConfigurableMatchPolicy configuredMatchPolicy = data_p.getMatchPolicy();
        if (originalMatchPolicy instanceof IConfigurablePolicy && configuredMatchPolicy != null) {
            ((IConfigurablePolicy)originalMatchPolicy).update((IConfigurablePolicy)configuredMatchPolicy);
        }
        IDiffPolicy originalDiffPolicy = this.getDiffPolicy();
        ConfigurableDiffPolicy configuredDiffPolicy = data_p.getDiffPolicy();
        if (originalDiffPolicy instanceof IConfigurablePolicy && configuredDiffPolicy != null) {
            ((IConfigurablePolicy)originalDiffPolicy).update((IConfigurablePolicy)configuredDiffPolicy);
        }
        IMergePolicy originalMergePolicy = this.getMergePolicy();
        ConfigurableMergePolicy configuredMergePolicy = data_p.getMergePolicy();
        if (originalMergePolicy instanceof IConfigurablePolicy && configuredMergePolicy != null) {
            ((IConfigurablePolicy)originalMergePolicy).update((IConfigurablePolicy)configuredMergePolicy);
        }
    }
}

