/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.diffmerge.generic.api.IDiffPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.generic.api.IMergePolicy;
import org.eclipse.emf.diffmerge.generic.api.Role;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonMethodFactory;
import org.eclipse.emf.diffmerge.ui.specification.IModelScopeDefinition;
import org.eclipse.emf.diffmerge.ui.specification.ext.AbstractComparisonMethod;

public abstract class DefaultComparisonMethod<E>
extends AbstractComparisonMethod<E> {
    private final Map<Role, IModelScopeDefinition> _roleToScopeDefinition;
    private Role _twoWayReferenceRole;
    protected IMatchPolicy<E> _matchPolicy;
    protected IDiffPolicy<E> _diffPolicy;
    protected IMergePolicy<E> _mergePolicy;

    public DefaultComparisonMethod(IModelScopeDefinition leftScopeDef_p, IModelScopeDefinition rightScopeDef_p, IModelScopeDefinition ancestorScopeDef_p, IComparisonMethodFactory<E> factory_p) {
        Role leftRole = this.getLeftRole();
        this._factory = factory_p;
        this._roleToScopeDefinition = new HashMap<Role, IModelScopeDefinition>();
        this._roleToScopeDefinition.put(leftRole, leftScopeDef_p);
        this._roleToScopeDefinition.put(leftRole.opposite(), rightScopeDef_p);
        this._roleToScopeDefinition.put(Role.ANCESTOR, ancestorScopeDef_p);
        this._twoWayReferenceRole = null;
        this._matchPolicy = this.createMatchPolicy();
        this._diffPolicy = this.createDiffPolicy();
        this._mergePolicy = this.createMergePolicy();
    }

    protected IDiffPolicy<E> createDiffPolicy() {
        return null;
    }

    protected IMatchPolicy<E> createMatchPolicy() {
        return null;
    }

    protected IMergePolicy<E> createMergePolicy() {
        return null;
    }

    @Override
    public IModelScopeDefinition getModelScopeDefinition(Role role_p) {
        return this._roleToScopeDefinition.get(role_p);
    }

    public IDiffPolicy<E> getDiffPolicy() {
        return this._diffPolicy;
    }

    public IMatchPolicy<E> getMatchPolicy() {
        return this._matchPolicy;
    }

    public IMergePolicy<E> getMergePolicy() {
        return this._mergePolicy;
    }

    @Override
    public Role getTwoWayReferenceRole() {
        return this._twoWayReferenceRole;
    }

    @Override
    public void setTwoWayReferenceRole(Role role_p) {
        if (!this.isThreeWay()) {
            this._twoWayReferenceRole = role_p;
        }
    }

    @Override
    public boolean swapScopeDefinitions(Role role1_p, Role role2_p) {
        boolean result = false;
        IModelScopeDefinition scope1 = this.getModelScopeDefinition(role1_p);
        IModelScopeDefinition scope2 = this.getModelScopeDefinition(role2_p);
        if (scope1 != null && scope2 != null) {
            this._roleToScopeDefinition.put(role1_p, scope2);
            this._roleToScopeDefinition.put(role2_p, scope1);
            result = true;
        }
        return result;
    }
}

