/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.xtext.resource.XtextResource;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.desc.CoreModelHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.resources.ResourceHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.cs.text.util.PluginUtil;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.AbstractFileCreationPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.AbstractSecondPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.AbstractThirdPage;
import org.polarsys.kitalpha.ad.viewpoint.dsl.services.cs.text.wizards.Messages;

public abstract class AbstractWizard
extends Wizard
implements INewWizard {
    protected IWorkbench workbench;
    protected IStructuredSelection selection;
    protected AbstractFileCreationPage firstPage;
    protected AbstractSecondPage secondPage;
    protected AbstractThirdPage thirdPage;
    protected String vpShortName;
    protected String vpTargetApplication;
    protected String vpDescriptionProjectName;
    protected String vpRootProjectName;
    protected String vpNsURI;
    protected String fileName;

    protected abstract boolean createFirstPage(IStructuredSelection var1);

    protected abstract boolean createSecondPage(IStructuredSelection var1);

    protected abstract boolean createThirdPage(IStructuredSelection var1);

    protected abstract void bindEditor(IFile var1);

    protected abstract String getInitialContent();

    protected abstract String getInitialContent(String var1);

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.workbench = workbench;
        this.selection = selection;
    }

    public void addPages() {
        super.addPages();
        if (this.createFirstPage(this.selection)) {
            this.addPage((IWizardPage)this.firstPage);
            EObject standaloneRoot = this.loadStandaloneResource();
            if (standaloneRoot != null) {
                this.setViewpointProperties(standaloneRoot);
            }
        }
        if (this.createSecondPage(this.selection)) {
            this.addPage((IWizardPage)this.secondPage);
        }
        if (this.createThirdPage(this.selection)) {
            this.addPage((IWizardPage)this.thirdPage);
        }
    }

    private EObject loadStandaloneResource() {
        IProject project = this.firstPage.getViewpointProject();
        if (project != null) {
            IFolder folder = this.firstPage.getViewpointProject().getFolder("model");
            if (!folder.exists()) {
                throw new RuntimeException(String.valueOf(Messages.AbstractWizard_ModelFolderNotFound) + project.getName());
            }
            URI standaloneResourceURI = ResourceHelper.getStandaloneResourceURI((String)project.getName());
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            Resource resource = resourceSet.getResource(standaloneResourceURI, true);
            return (EObject)resource.getContents().get(0);
        }
        return null;
    }

    private void setViewpointProperties(EObject root) {
        this.setVpShortName(CoreModelHelper.getViewpointShortName((Object)root));
        this.setVpTargetApplication(VpDslConfigurationHelper.getTargetApplication((Object)root));
        this.setVpRootProjectName(VpDslConfigurationHelper.getRootProjectName((Object)root));
        this.setVpDescriptionProjectName(this.firstPage.getViewpointProject().getName());
        this.setVpNsURI(VpDslConfigurationHelper.getNsURI((Object)root));
    }

    public boolean performFinish() {
        boolean result = false;
        IFile file = this.createNewFile();
        this.createResource(file);
        boolean bl = result = file != null;
        if (result) {
            try {
                this.fileName = file.getName();
                this.bindEditor(file);
                IDE.openEditor((IWorkbenchPage)this.workbench.getActiveWorkbenchWindow().getActivePage(), (IFile)file);
            }
            catch (PartInitException ex) {
                ex.printStackTrace();
            }
        }
        return result;
    }

    public IFile createNewFile() {
        return this.firstPage.createNewFile();
    }

    private void createResource(final IFile file) {
        try {
            new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.AbstractWizard_FileCreationTaskTitle, -1);
                    ResourceSetImpl resourceSet = new ResourceSetImpl();
                    URI uri = ResourceHelper.URIFix.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true);
                    URI normalized = resourceSet.getURIConverter().normalize(uri);
                    XtextResource resource = (XtextResource)ResourceHelper.loadResource((URI)normalized, (ResourceSet)resourceSet);
                    try {
                        String fileName = AbstractWizard.this.firstPage.getFileName();
                        resource.reparse(AbstractWizard.this.getInitialContent(fileName));
                        resource.save(Collections.emptyMap());
                        PluginUtil.addModelReuseExtension((String)fileName, (String)AbstractWizard.this.vpDescriptionProjectName, (String)AbstractWizard.this.vpShortName, (URI)uri);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                    monitor.done();
                }
            }.run(AbstractWizard.monitor());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void setVpShortName(String vpShortName) {
        this.vpShortName = vpShortName;
    }

    public void setVpTargetApplication(String vpTargetApplication) {
        this.vpTargetApplication = vpTargetApplication;
    }

    public void setVpDescriptionProjectName(String vpDescriptionProjectName) {
        this.vpDescriptionProjectName = vpDescriptionProjectName;
    }

    public void setVpRootProjectName(String vpRootProjectName) {
        this.vpRootProjectName = vpRootProjectName;
    }

    private void setVpNsURI(String nsURI) {
        this.vpNsURI = nsURI;
    }

    public String getVpShortName() {
        return this.vpShortName;
    }

    public String getVpTargetApplication() {
        return this.vpTargetApplication;
    }

    public String getVpDescriptionProjectName() {
        return this.vpDescriptionProjectName;
    }

    public String getVpRootProjectName() {
        return this.vpRootProjectName;
    }

    public String getVpNsURI() {
        return this.vpNsURI;
    }

    public String getFileName() {
        return this.fileName;
    }

    public static IProgressMonitor monitor() {
        return new NullProgressMonitor();
    }
}

