/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.diagram.javaservice.JavaMethodData;

public class JavaServiceData {
    private String packageName;
    private String className;
    private List<JavaMethodData> methods = new ArrayList<JavaMethodData>();
    private EObject context;

    public JavaServiceData(String pack, String clazz) {
        this.packageName = pack;
        this.className = clazz;
    }

    public JavaServiceData(String name) {
        String[] nameElement = name.split("\\.");
        this.packageName = nameElement[0];
        this.className = nameElement[nameElement.length - 1];
        int i = 1;
        while (i < nameElement.length - 1) {
            this.packageName = String.valueOf(this.packageName) + "." + nameElement[i];
            ++i;
        }
    }

    public List<String> getAllRequiredClassesFQN() {
        ArrayList<String> result = new ArrayList<String>();
        for (JavaMethodData javaMethodData : this.methods) {
            List<String> requiredClassesFQN = javaMethodData.getRequiredClassesFQN();
            for (String classFQN : requiredClassesFQN) {
                if (result.contains(classFQN)) continue;
                result.add(classFQN);
            }
        }
        return result;
    }

    public void addMethod(String methodName, JavaMethodData.JavaMethodReturnType methodReturnType) {
        JavaMethodData methodData = new JavaMethodData(methodName, methodReturnType);
        this.addMethod(methodData);
    }

    public void addMethod(JavaMethodData methodData) {
        if (!this.isAvailable(methodData)) {
            this.methods.add(methodData);
        }
    }

    public boolean isAvailable(JavaMethodData methodData) {
        for (JavaMethodData iJavaMethodData : this.methods) {
            if (!iJavaMethodData.equals(methodData)) continue;
            return true;
        }
        return false;
    }

    public EObject getContext() {
        return this.context;
    }

    public void setContext(EObject context) {
        if (this.context == null || this.context != context) {
            this.context = context;
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public List<JavaMethodData> getMethods() {
        return this.methods;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof JavaServiceData) {
            JavaServiceData foreignJavaServiceData = (JavaServiceData)arg0;
            String foreignPackage = foreignJavaServiceData.getPackageName();
            String foreignClass = foreignJavaServiceData.getClassName();
            List<JavaMethodData> foreignMethods = foreignJavaServiceData.getMethods();
            if (this.packageName.equals(foreignPackage.toLowerCase()) || this.className.equals(foreignClass.toLowerCase())) {
                return false;
            }
            if (this.methods.size() != foreignMethods.size()) {
                return false;
            }
            for (JavaMethodData iMethod : this.methods) {
                boolean found = false;
                for (JavaMethodData jMethod : foreignMethods) {
                    if (!iMethod.equals(jMethod)) continue;
                    found = true;
                }
                if (found) continue;
                return false;
            }
            return true;
        }
        return super.equals(arg0);
    }
}

