/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.business.queries.queries.information;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.polarsys.capella.common.data.modellingcore.AbstractNamedElement;
import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.ModelElement;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.queries.AbstractQuery;
import org.polarsys.capella.common.queries.queryContext.IQueryContext;
import org.polarsys.capella.core.business.abstractqueries.helpers.CapellaElementsHelperForBusinessQueries;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.data.capellacore.GeneralizableElement;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.CsPackage;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.helpers.capellacore.services.GeneralizableElementExt;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.Collection;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.InformationPackage;
import org.polarsys.capella.core.data.information.MultiplicityElement;
import org.polarsys.capella.core.data.information.Property;
import org.polarsys.capella.core.data.information.datatype.BooleanType;
import org.polarsys.capella.core.data.information.datatype.Enumeration;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.model.helpers.CapellaElementExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class GetAvailable_Collection_NullValue
extends AbstractQuery {
    public List<Object> execute(Object input, IQueryContext context) {
        CapellaElement capellaElement = (CapellaElement)input;
        List<EObject> availableElements = this.getAvailableElements(capellaElement);
        return availableElements;
    }

    protected List<EObject> filterUnNamedElements(List<EObject> list) {
        ArrayList<EObject> result = new ArrayList<EObject>(1);
        for (EObject capellaElement : list) {
            String name;
            if (!(capellaElement instanceof AbstractNamedElement) || (name = ((AbstractNamedElement)capellaElement).getName()) == null || "".equals(name)) continue;
            result.add(capellaElement);
        }
        return result;
    }

    public List<EObject> getAvailableElements(CapellaElement element) {
        List<EObject> returnValue = new ArrayList<EObject>();
        BlockArchitecture currentBlockArchitecture = DataPkgExt.getRootBlockArchitecture((ModelElement)element);
        SystemEngineering systemEngineering = SystemEngineeringExt.getSystemEngineering((CapellaElement)element);
        OperationalAnalysis operationalAnalysis = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)operationalAnalysis, element));
        if (!(currentBlockArchitecture instanceof OperationalAnalysis)) {
            SystemAnalysis systemAnalysis = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            returnValue.addAll(this.getDataFromLevel((BlockArchitecture)systemAnalysis, element));
            if (!(currentBlockArchitecture instanceof SystemAnalysis)) {
                LogicalArchitecture logicalArchitecture = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
                returnValue.addAll(this.getDataFromLevel((BlockArchitecture)logicalArchitecture, element));
                if (!(currentBlockArchitecture instanceof LogicalArchitecture)) {
                    PhysicalArchitecture physicalArchitecture = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
                    returnValue.addAll(this.getDataFromLevel((BlockArchitecture)physicalArchitecture, element));
                    if (!(currentBlockArchitecture instanceof PhysicalArchitecture)) {
                        EPBSArchitecture epbsArchitecture = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering);
                        returnValue.addAll(this.getDataFromLevel((BlockArchitecture)epbsArchitecture, element));
                    }
                }
            }
        }
        returnValue.addAll(this.getUnlevelizedData(element));
        returnValue.addAll(this.getDataFromComponentHierarchy(element));
        returnValue.addAll(this.getDataFromRealizedComponentsHierarchy(element));
        returnValue.addAll(this.getTypesFromComponentHierarchy(element));
        returnValue = this.filterUnNamedElements(returnValue);
        return returnValue;
    }

    protected List<CapellaElement> getDataFromComponentHierarchy(CapellaElement element) {
        ArrayList<CapellaElement> allDatas = new ArrayList<CapellaElement>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(this.getDataFromLevel(dataPkg, element));
        }
        return allDatas;
    }

    public List<CapellaElement> getDataFromLevel(BlockArchitecture blockArchitecture, CapellaElement capellaElement) {
        DataPkg dataPkg;
        if (blockArchitecture != null && (dataPkg = blockArchitecture.getOwnedDataPkg()) != null) {
            return this.getDataFromLevel(dataPkg, capellaElement);
        }
        return Collections.emptyList();
    }

    public List<CapellaElement> getDataFromLevel(DataPkg dataPkg, CapellaElement capellaElement) {
        List<CapellaElement> dataFromLevel = this.super_getDataFromLevel(dataPkg, capellaElement);
        if (capellaElement instanceof MultiplicityElement) {
            dataFromLevel.addAll(CapellaElementsHelperForBusinessQueries.getApplicableValuesForMultEleConsideringSuperGenElements(dataPkg, (MultiplicityElement)capellaElement, this.getEStructuralFeatures()));
        }
        return dataFromLevel;
    }

    protected List<CapellaElement> getDataFromRealizedComponentsHierarchy(CapellaElement element) {
        Component currentCpnt;
        ArrayList<CapellaElement> allDatas = new ArrayList<CapellaElement>();
        Component component = currentCpnt = element instanceof Component ? (Component)element : null;
        if (currentCpnt == null) {
            currentCpnt = (Component)EcoreUtil2.getFirstContainer((EObject)element, (EClass)CsPackage.Literals.COMPONENT);
        }
        if (currentCpnt != null) {
            for (Component allocatedCpnt : currentCpnt.getRealizedComponents()) {
                List componentHierarchy = CapellaElementExt.getComponentHierarchy((CapellaElement)allocatedCpnt);
                componentHierarchy.add(allocatedCpnt);
                for (Component cpnt : componentHierarchy) {
                    DataPkg dataPkg = cpnt.getOwnedDataPkg();
                    if (dataPkg == null) continue;
                    for (CapellaElement data : this.getDataFromLevel(dataPkg, element)) {
                        if (allDatas.contains(data)) continue;
                        allDatas.add(data);
                    }
                }
            }
        }
        return allDatas;
    }

    public List<EReference> getEStructuralFeatures() {
        return Collections.singletonList(InformationPackage.Literals.MULTIPLICITY_ELEMENT__OWNED_NULL_VALUE);
    }

    protected List<EObject> getTypesFromComponentHierarchy(CapellaElement element) {
        List<EObject> allDatas = new ArrayList<EObject>();
        for (Component cpnt : CapellaElementExt.getComponentHierarchy((CapellaElement)element)) {
            DataPkg dataPkg = cpnt.getOwnedDataPkg();
            if (dataPkg == null) continue;
            allDatas.addAll(DataPkgExt.getAllTypesFromDataPkg((DataPkg)dataPkg));
        }
        allDatas = this.removeNonPrimitiveClasses(allDatas);
        allDatas = this.removeNonPrimitiveCollections(allDatas);
        return allDatas;
    }

    public List<CapellaElement> getUnlevelizedData(CapellaElement capellaElement) {
        ArrayList<CapellaElement> returnValue;
        block2: {
            AbstractType type;
            block3: {
                returnValue = new ArrayList<CapellaElement>();
                if (!(capellaElement instanceof Property) || (type = ((Property)capellaElement).getAbstractType()) == null) break block2;
                if (!(type instanceof Enumeration)) break block3;
                List rootSupertypes = GeneralizableElementExt.getRootSupertypes((GeneralizableElement)((Enumeration)type));
                rootSupertypes.add((GeneralizableElement)type);
                for (CapellaElement melElem : rootSupertypes) {
                    if (!(melElem instanceof Enumeration)) continue;
                    Enumeration rootBooleanType = (Enumeration)melElem;
                    returnValue.addAll((java.util.Collection<CapellaElement>)rootBooleanType.getOwnedLiterals());
                }
                break block2;
            }
            if (!(type instanceof BooleanType)) break block2;
            List rootSupertypes = GeneralizableElementExt.getRootSupertypes((GeneralizableElement)((BooleanType)type));
            rootSupertypes.add((GeneralizableElement)type);
            for (CapellaElement melElem : rootSupertypes) {
                if (!(melElem instanceof BooleanType)) continue;
                BooleanType rootBooleanType = (BooleanType)melElem;
                returnValue.addAll((java.util.Collection<CapellaElement>)rootBooleanType.getOwnedLiterals());
            }
        }
        return returnValue;
    }

    protected List<EObject> removeNonPrimitiveClasses(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveClasses(elements, false);
    }

    protected List<EObject> removeNonPrimitiveCollections(List<EObject> elements) {
        return this.removePrimitiveOrNonPrimitiveCollections(elements, false);
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveClasses(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Class) {
                Class currentClass = (Class)element;
                if ((removePrimitive || !currentClass.isIsPrimitive()) && (!removePrimitive || currentClass.isIsPrimitive())) continue;
                returnValue.add((EObject)currentClass);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    protected List<EObject> removePrimitiveOrNonPrimitiveCollections(List<EObject> elements, boolean removePrimitive) {
        ArrayList<EObject> returnValue = new ArrayList<EObject>();
        for (EObject element : elements) {
            if (element instanceof Collection) {
                Collection currentCollection = (Collection)element;
                if ((removePrimitive || !currentCollection.isIsPrimitive()) && (!removePrimitive || currentCollection.isIsPrimitive())) continue;
                returnValue.add((EObject)currentCollection);
                continue;
            }
            returnValue.add(element);
        }
        return returnValue;
    }

    public List<CapellaElement> super_getDataFromLevel(DataPkg dataPkg, CapellaElement capellaElement) {
        if (capellaElement instanceof MultiplicityElement) {
            List<CapellaElement> returnValue = CapellaElementsHelperForBusinessQueries.getStandardApplicableValuesForMultiplicityElementInLevel(dataPkg, (MultiplicityElement)capellaElement, this.getEStructuralFeatures());
            returnValue.addAll(CapellaElementsHelperForBusinessQueries.getPropertiesWithTypeOf(dataPkg, capellaElement));
            return returnValue;
        }
        return Collections.emptyList();
    }
}

