/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui;

import java.util.stream.Stream;
import org.eclipse.gmf.runtime.common.ui.services.action.global.IGlobalActionContext;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.NoteEditPart;
import org.eclipse.gmf.runtime.diagram.ui.internal.editparts.TextEditPart;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.diagram.ui.tools.internal.clipboard.SiriusClipboardGlobalActionHandler;

public class CapellaGlobalActionHandler
extends SiriusClipboardGlobalActionHandler {
    public boolean canPaste(IGlobalActionContext context) {
        return super.canPaste(context) && this.isDiagram(context);
    }

    protected boolean canCopy(IGlobalActionContext context) {
        return this.isNote(context);
    }

    protected boolean canCut(IGlobalActionContext context) {
        return super.canCut(context) && this.isNote(context);
    }

    private boolean isNote(IGlobalActionContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.isEmpty()) {
                return false;
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (Stream<Object> stream = Stream.of(structuredSelection.toArray());){
                return stream.allMatch(entry -> entry instanceof NoteEditPart || entry instanceof TextEditPart);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return true;
    }

    private boolean isDiagram(IGlobalActionContext context) {
        ISelection selection = context.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            if (structuredSelection.isEmpty()) {
                return false;
            }
            Throwable throwable = null;
            Object var5_6 = null;
            try (Stream<Object> stream = Stream.of(structuredSelection.toArray());){
                return stream.allMatch(DiagramEditPart.class::isInstance);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return true;
    }
}

