/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.actions;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.command.MoveRepresentationCommand;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelector;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSelectorService;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.sirius.diagram.business.api.query.EObjectQuery;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.viewpoint.DAnalysis;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.ViewpointPackage;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.polarsys.capella.core.model.handler.helpers.RepresentationHelper;
import org.polarsys.capella.core.sirius.ui.Messages;

public class MoveRepresentationsAction
extends BaseSelectionListenerAction {
    public MoveRepresentationsAction() {
        super(Messages.MoveRepresentationsAction_move);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        List<DRepresentationDescriptor> validRepresentationDescriptors = this.getValidRepresentationDescriptors(selection);
        List sessions = validRepresentationDescriptors.stream().map(repDesc -> (Session)Session.of((EObject)repDesc).orElseGet(null)).filter(s -> s != null).distinct().collect(Collectors.toList());
        if (sessions.size() == 1) {
            Session session = (Session)sessions.get(0);
            return session.getAllSessionResources().size() > 1;
        }
        return false;
    }

    private List<DRepresentationDescriptor> getValidRepresentationDescriptors(IStructuredSelection selection) {
        return RepresentationHelper.getSelectedDescriptors((Collection)selection.toList()).stream().filter(RepresentationHelper::isValid).collect(Collectors.toList());
    }

    public void run() {
        List<DRepresentationDescriptor> repDescriptors = this.getValidRepresentationDescriptors(this.getStructuredSelection());
        if (repDescriptors.isEmpty()) {
            return;
        }
        DRepresentationDescriptor next = (DRepresentationDescriptor)repDescriptors.iterator().next();
        Session session = SessionManager.INSTANCE.getSession(next.getTarget());
        DAnalysisSelector dAnalysisSelector = DAnalysisSelectorService.getSelector((DAnalysisSession)((DAnalysisSession)session));
        for (DRepresentationDescriptor dRepresentationDescriptor : repDescriptors) {
            Option dAnalysisOption = new EObjectQuery((EObject)dRepresentationDescriptor).getFirstAncestorOfType(ViewpointPackage.eINSTANCE.getDAnalysis());
            Collection analysesCandidates = ((DAnalysisSession)session).allAnalyses();
            analysesCandidates.remove(dAnalysisOption.get());
            try {
                DAnalysis selectedDAnalysis = dAnalysisSelector.selectSmartlyAnalysisForAddedRepresentation(dRepresentationDescriptor.getRepresentation(), analysesCandidates);
                if (selectedDAnalysis == dAnalysisOption.get()) continue;
                session.getTransactionalEditingDomain().getCommandStack().execute((Command)new MoveRepresentationCommand(session, selectedDAnalysis, Collections.singleton(dRepresentationDescriptor)));
            }
            catch (OperationCanceledException operationCanceledException) {
                // empty catch block
            }
        }
    }
}

