/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.commandline;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.common.tools.api.resource.ImageFileFormat;
import org.eclipse.sirius.ui.tools.api.actions.export.ExportAction;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.core.commandline.core.CommandLineException;
import org.polarsys.capella.core.commandline.core.Messages;
import org.polarsys.capella.core.commandline.core.ui.AbstractWorkbenchCommandLine;
import org.polarsys.capella.core.model.handler.command.CapellaResourceHelper;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.commandline.ExportRepresentationsArgumentHelper;

public class ExportRepresentationsCommandLine
extends AbstractWorkbenchCommandLine {
    public ExportRepresentationsCommandLine() {
        this.argHelper = new ExportRepresentationsArgumentHelper();
    }

    protected IStatus executeWithinWorkbench() {
        ExportRepresentationsArgumentHelper args = (ExportRepresentationsArgumentHelper)this.argHelper;
        List airdFiles = this.getAirdFilesFromInput();
        for (IFile file : airdFiles) {
            URI uri = EcoreUtil2.getURI((IFile)file);
            Session session = SessionManager.INSTANCE.getSession(uri, (IProgressMonitor)new NullProgressMonitor());
            if (session == null) {
                return new Status(4, SiriusUIPlugin.getDefault().getPluginId(), "No aird model found!");
            }
            if (!session.isOpen()) {
                session.open((IProgressMonitor)new NullProgressMonitor());
            }
            if (!CapellaResourceHelper.isAirdResource((URI)uri)) continue;
            Collection representations = DialectManager.INSTANCE.getAllRepresentations(session);
            IPath outputPath = this.getOrCreateOutputFolderForAird(uri).getLocation();
            ImageFileFormat imageFormat = ImageFileFormat.resolveImageFormat((String)args.getImageFormat());
            boolean exportToHtml = args.getExportToHtml();
            boolean exportDecorations = args.getExportDecorations();
            ExportAction exportRepresentationsAction = new ExportAction(session, representations, outputPath, imageFormat, exportToHtml, exportDecorations);
            try {
                exportRepresentationsAction.run((IProgressMonitor)new NullProgressMonitor());
            }
            catch (InterruptedException e1) {
                return Status.CANCEL_STATUS;
            }
            catch (InvocationTargetException e) {
                return new Status(4, SiriusUIPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e);
            }
            catch (Exception e) {
                return new Status(4, SiriusUIPlugin.getDefault().getPluginId(), e.getMessage(), (Throwable)e);
            }
        }
        return Status.OK_STATUS;
    }

    public void checkArgs(IApplicationContext context) throws CommandLineException {
        super.checkArgs(context);
        if (this.argHelper.getOutputFolder() == null) {
            this.logger.error((Object)Messages.outputfolder_mandatory);
        }
    }

    public void printHelp() {
        super.printHelp(Arrays.asList("outputfolder"));
        this.printArgumentsFromTable("exportRepresentationsParameters", false, Collections.emptyList());
    }
}

