/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.editor;

import java.lang.ref.WeakReference;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.danalysis.DAnalysisSession;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.common.mdsofa.common.helper.FileHelper;
import org.polarsys.capella.common.tools.report.EmbeddedMessage;
import org.polarsys.capella.common.tools.report.config.registry.ReportManagerRegistry;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.sirius.ui.SiriusUIPlugin;
import org.polarsys.capella.core.sirius.ui.actions.OpenSessionAction;
import org.polarsys.capella.core.sirius.ui.editor.CapellaDashboardEditorInputFactory;
import org.polarsys.capella.core.sirius.ui.helper.SessionHelper;

public class CapellaDashboardEditorInput
implements IEditorInput,
IPersistableElement {
    private static final Logger __logger = ReportManagerRegistry.getInstance().subscribe("User Interface");
    private static final String FIRST_ANALYSIS_FILE_TAG = "firstAnalysisFile";
    private WeakReference<Session> _sessionReference;
    private WeakReference<Project> _capellaProjectReference;
    private IStatus _sessionStatus;

    CapellaDashboardEditorInput(IMemento memento_p) {
        this._sessionStatus = Status.OK_STATUS;
        this.loadState(memento_p);
    }

    public CapellaDashboardEditorInput(Session session_p, Project capellaProject_p) {
        this._sessionReference = new WeakReference<Session>(session_p);
        this._capellaProjectReference = new WeakReference<Project>(capellaProject_p);
        this._sessionStatus = Status.OK_STATUS;
    }

    public void dispose() {
        this._capellaProjectReference.clear();
        this._capellaProjectReference = null;
        this._sessionReference.clear();
        this._sessionReference = null;
    }

    public boolean equals(Object obj_p) {
        WeakReference<Session> sessionReferenceToCompare;
        Session session;
        boolean result;
        boolean bl = result = this == obj_p;
        if (!result && this._sessionReference != null && obj_p instanceof CapellaDashboardEditorInput && (session = (Session)this._sessionReference.get()) != null && (sessionReferenceToCompare = ((CapellaDashboardEditorInput)obj_p)._sessionReference) != null) {
            result = session.equals(sessionReferenceToCompare.get());
        }
        return result;
    }

    public boolean exists() {
        boolean result = false;
        if (this._sessionReference != null) {
            Session session = (Session)this._sessionReference.get();
            result = session != null && session.isOpen();
        }
        return result;
    }

    public Object getAdapter(Class adapter_p) {
        if (this._sessionReference != null && adapter_p == Session.class) {
            return this._sessionReference.get();
        }
        return null;
    }

    public String getFactoryId() {
        return CapellaDashboardEditorInputFactory.ID;
    }

    public ImageDescriptor getImageDescriptor() {
        return null;
    }

    public String getCapellaModelUiName() {
        Project project;
        String result = "";
        if (this._capellaProjectReference != null && (project = (Project)this._capellaProjectReference.get()) != null) {
            result = EObjectLabelProviderHelper.getText((Object)project);
        }
        return result;
    }

    public Project getCapellaProject() {
        Project result = null;
        if (this._capellaProjectReference != null) {
            result = (Project)this._capellaProjectReference.get();
        }
        return result;
    }

    public String getName() {
        return this.getCapellaModelUiName();
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public Session getSession() {
        return (Session)this.getAdapter(Session.class);
    }

    public String getToolTipText() {
        return this.getName();
    }

    public int hashCode() {
        int hashCode = super.hashCode();
        if (this._sessionReference != null) {
            Session session = (Session)this._sessionReference.get();
            hashCode = session != null ? session.hashCode() : hashCode;
        }
        return hashCode;
    }

    protected void loadState(IMemento memento_p) {
        String firstAnalysisFile = memento_p.getString(FIRST_ANALYSIS_FILE_TAG);
        if (firstAnalysisFile == null) {
            return;
        }
        IFile diagramFile = FileHelper.getPlatformFile((String)firstAnalysisFile);
        try {
            Session session = SessionHelper.getSession(diagramFile);
            if (session == null) {
                OpenSessionAction openSessionAction = new OpenSessionAction();
                openSessionAction.setOpenActivityExplorer(false);
                openSessionAction.setRunInProgressService(false);
                openSessionAction.selectionChanged((IStructuredSelection)new StructuredSelection((Object)diagramFile));
                openSessionAction.run();
                if (openSessionAction.getFailedOpeningSessions().containsKey(diagramFile)) {
                    IStatus status = openSessionAction.getFailedOpeningSessions().get(diagramFile);
                    this._sessionStatus = new Status(4, SiriusUIPlugin.getDefault().getPluginId(), NLS.bind((String)"Error while opening session {0} [{1}]", (Object)firstAnalysisFile, (Object)status.getMessage()), status.getException());
                }
                session = SessionHelper.getSession(diagramFile);
            }
            this._sessionReference = new WeakReference<Session>(session);
            if (this._sessionReference.get() != null) {
                this._capellaProjectReference = new WeakReference<Project>(SessionHelper.getCapellaProject((Session)this._sessionReference.get()));
            }
        }
        catch (Exception e) {
            this._sessionStatus = new Status(4, SiriusUIPlugin.getDefault().getPluginId(), NLS.bind((String)"Error while opening session {0} [{1}]", (Object)firstAnalysisFile, (Object)e.getMessage()), (Throwable)e);
            __logger.error((Object)new EmbeddedMessage(e.getMessage(), "User Interface"), (Throwable)e);
        }
    }

    public IStatus getStatus() {
        return this._sessionStatus;
    }

    public void saveState(IMemento memento_p) {
        if (this._sessionReference == null || this._sessionReference.get() == null) {
            return;
        }
        IFile firstAnalysisFile = SessionHelper.getFirstAnalysisFile((DAnalysisSession)this._sessionReference.get());
        if (firstAnalysisFile != null) {
            memento_p.putString(FIRST_ANALYSIS_FILE_TAG, firstAnalysisFile.getFullPath().toString());
        }
    }

    static CapellaDashboardEditorInput create(IMemento memento_p) {
        CapellaDashboardEditorInput result = new CapellaDashboardEditorInput(memento_p);
        return result;
    }
}

