/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.sirius.ui.runnable;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.Request;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.requests.ArrangeRequest;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.ui.business.api.dialect.DialectUIManager;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

public class OpenRepresentationsRunnable
implements IRunnableWithProgress {
    private Collection<DRepresentationDescriptor> _descriptors;
    private boolean _arrangeAll;

    public OpenRepresentationsRunnable(Collection<DRepresentationDescriptor> descriptors, boolean arrangeAll) {
        this._descriptors = descriptors;
        this._arrangeAll = arrangeAll;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)1);
        SubMonitor loopProgress = progress.newChild(1).setWorkRemaining(this._descriptors.size());
        for (DRepresentationDescriptor representation : this._descriptors) {
            IEditorPart part;
            EObject semantic = representation.getTarget();
            Session session = SessionManager.INSTANCE.getSession(semantic);
            if (session != null && (part = DialectUIManager.INSTANCE.openEditor(session, representation.getRepresentation(), (IProgressMonitor)new NullProgressMonitor())) != null && this._arrangeAll && part instanceof DiagramEditor) {
                this.arrangeAll((DiagramEditor)part);
            }
            loopProgress.worked(1);
        }
    }

    private void arrangeAll(DiagramEditor part) {
        DiagramEditor editor = part;
        final DiagramEditPart diagramEditPart = editor.getDiagramEditPart();
        ArrayList editParts = new ArrayList();
        editParts.addAll(diagramEditPart.getChildren());
        ArrangeRequest arrangeRequest = new ArrangeRequest("arrange_deferred");
        arrangeRequest.setViewAdaptersToArrange(editParts);
        diagramEditPart.deactivate();
        diagramEditPart.performRequest((Request)arrangeRequest);
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                diagramEditPart.activate();
            }
        });
    }
}

