/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.diffmerge.patterns.diagrams.sirius.util.SiriusLayersUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.diagram.AbstractDNode;
import org.eclipse.sirius.diagram.DDiagram;
import org.eclipse.sirius.diagram.DDiagramElement;
import org.eclipse.sirius.diagram.DDiagramElementContainer;
import org.eclipse.sirius.diagram.DNode;
import org.eclipse.sirius.diagram.DNodeContainer;
import org.eclipse.sirius.diagram.business.api.componentization.DiagramComponentizationManager;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.IContainerMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.extensions.INodeMappingExt;
import org.eclipse.sirius.diagram.business.internal.metamodel.description.operations.SiriusElementMappingSpecOperations;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.ContainerMappingWithInterpreterHelper;
import org.eclipse.sirius.diagram.business.internal.metamodel.helper.NodeMappingHelper;
import org.eclipse.sirius.diagram.description.AbstractNodeMapping;
import org.eclipse.sirius.diagram.description.ContainerMapping;
import org.eclipse.sirius.diagram.description.ContainerMappingImport;
import org.eclipse.sirius.diagram.description.DescriptionPackage;
import org.eclipse.sirius.diagram.description.DiagramDescription;
import org.eclipse.sirius.diagram.description.DiagramElementMapping;
import org.eclipse.sirius.diagram.description.Layer;
import org.eclipse.sirius.diagram.description.NodeMapping;
import org.eclipse.sirius.diagram.description.NodeMappingImport;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessor;
import org.eclipse.sirius.ecore.extender.business.api.accessor.ModelAccessorsRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.SiriusPlugin;
import org.eclipse.sirius.viewpoint.description.AbstractMappingImport;

public final class SiriusUtil {
    private SiriusUtil() {
    }

    public static boolean conformsToMapping(EObject semanticElt_p, AbstractNodeMapping mapping_p, boolean considerPrecondition_p, boolean considerCandidates_p, Object graphicalContainer_p) {
        boolean result = false;
        if (graphicalContainer_p instanceof DDiagram || graphicalContainer_p instanceof DDiagramElementContainer) {
            EObject container = (EObject)graphicalContainer_p;
            ModelAccessorsRegistry reg = SiriusPlugin.getDefault().getModelAccessorRegistry();
            ModelAccessor accessor = reg.getModelAccessor(semanticElt_p);
            if (accessor != null) {
                String domainClass = mapping_p.getDomainClass();
                result = accessor.eInstanceOf(semanticElt_p, domainClass);
                EObject semanticOfGraphicalContainer = SiriusLayersUtil.getSemanticElement(container);
                if (result && considerPrecondition_p) {
                    result = SiriusElementMappingSpecOperations.checkPrecondition((DiagramElementMapping)mapping_p, (EObject)semanticElt_p, (EObject)semanticOfGraphicalContainer, (EObject)container);
                }
                if (result && considerCandidates_p) {
                    List candidates = null;
                    if (mapping_p instanceof INodeMappingExt) {
                        INodeMappingExt nm = (INodeMappingExt)mapping_p;
                        NodeMappingHelper.clearDNodesDone((INodeMappingExt)nm);
                        candidates = NodeMappingHelper.getNodesCandidates((INodeMappingExt)nm, (EObject)semanticOfGraphicalContainer, (EObject)semanticOfGraphicalContainer, (EObject)container);
                    } else if (mapping_p instanceof IContainerMappingExt) {
                        IContainerMappingExt cm = (IContainerMappingExt)mapping_p;
                        ContainerMappingWithInterpreterHelper.clearDNodesDone((IContainerMappingExt)cm);
                        candidates = ContainerMappingWithInterpreterHelper.getNodesCandidates((IContainerMappingExt)cm, (EObject)semanticOfGraphicalContainer, (EObject)semanticOfGraphicalContainer, (EObject)container);
                    }
                    result = candidates != null && candidates.contains(semanticElt_p);
                }
            }
        }
        return result;
    }

    public static UniqueEList<AbstractNodeMapping> getApplicableMappingsIn(EObject graphicalContainer_p) {
        Object result = null;
        result = graphicalContainer_p instanceof DDiagram ? SiriusUtil.getApplicableMappingsInDiagram((DDiagram)graphicalContainer_p) : (graphicalContainer_p instanceof DNodeContainer ? SiriusUtil.getApplicableMappingsInContainer((DNodeContainer)graphicalContainer_p) : new UniqueEList());
        return result;
    }

    private static UniqueEList<AbstractNodeMapping> getApplicableMappingsInDiagram(DDiagram diagram_p) {
        UniqueEList result = new UniqueEList();
        DiagramDescription desc = diagram_p.getDescription();
        result.addAll((Collection)desc.getContainerMappings());
        result.addAll((Collection)desc.getNodeMappings());
        for (DiagramElementMapping reusedMapping : desc.getReusedMappings()) {
            if (!(reusedMapping instanceof AbstractNodeMapping)) continue;
            result.add((Object)((AbstractNodeMapping)reusedMapping));
        }
        Session session = SessionManager.INSTANCE.getSession((EObject)diagram_p);
        Collection selectedViewpoints = session.getSelectedViewpoints(false);
        EList layers = new DiagramComponentizationManager().getAllLayers(selectedViewpoints, diagram_p.getDescription());
        for (Layer layer : layers) {
            result.addAll((Collection)layer.getContainerMappings());
            result.addAll((Collection)layer.getNodeMappings());
            for (DiagramElementMapping reusedMapping : layer.getReusedMappings()) {
                if (!(reusedMapping instanceof AbstractNodeMapping)) continue;
                result.add((Object)((AbstractNodeMapping)reusedMapping));
            }
        }
        return result;
    }

    public static List<Object> getAllDiagramElements(Collection<Object> roots_p) {
        LinkedList<Object> result = new LinkedList<Object>(roots_p);
        for (Object root : roots_p) {
            if (!(root instanceof DDiagramElement)) continue;
            SiriusUtil.getAllDiagramElementsRec((DDiagramElement)root, result);
        }
        return Collections.unmodifiableList(result);
    }

    private static void getAllDiagramElementsRec(DDiagramElement root_p, List<Object> result_p) {
        if (root_p instanceof AbstractDNode) {
            AbstractDNode aNode = (AbstractDNode)root_p;
            result_p.addAll((Collection<Object>)aNode.getOwnedBorderedNodes());
            if (aNode instanceof DDiagramElementContainer) {
                DDiagramElementContainer container = (DDiagramElementContainer)aNode;
                result_p.addAll((Collection<Object>)container.getNodes());
                EList subContainers = container.getContainers();
                result_p.addAll((Collection<Object>)subContainers);
                for (DDiagramElementContainer subContainer : subContainers) {
                    SiriusUtil.getAllDiagramElementsRec((DDiagramElement)subContainer, result_p);
                }
            }
        }
    }

    private static UniqueEList<AbstractNodeMapping> getApplicableMappingsInContainer(DNodeContainer nodeContainer_p) {
        UniqueEList result = new UniqueEList();
        ContainerMapping mapping = nodeContainer_p.getActualMapping();
        result.addAll((Collection)mapping.getReusedNodeMappings());
        result.addAll((Collection)mapping.getSubNodeMappings());
        result.addAll((Collection)mapping.getReusedContainerMappings());
        result.addAll((Collection)mapping.getSubContainerMappings());
        return result;
    }

    public static DDiagram getDiagram(EObject context_p) {
        DDiagram result = null;
        if (context_p instanceof DDiagram) {
            result = (DDiagram)context_p;
        } else if (context_p instanceof DDiagramElement) {
            result = ((DDiagramElement)context_p).getParentDiagram();
        }
        return result;
    }

    public static boolean isBorderedNode(DNode node_p) {
        boolean result = false;
        NodeMapping mapping = node_p.getActualMapping();
        if (mapping != null) {
            result = mapping.eContainmentFeature() == DescriptionPackage.eINSTANCE.getAbstractNodeMapping_BorderedNodeMappings();
        }
        return result;
    }

    public static UniqueEList<AbstractNodeMapping> reduceByImport(Collection<AbstractNodeMapping> mappings_p) {
        UniqueEList result = new UniqueEList(mappings_p);
        for (AbstractNodeMapping mapping : mappings_p) {
            if (!(mapping instanceof AbstractMappingImport)) continue;
            AbstractMappingImport importMapping = (AbstractMappingImport)mapping;
            NodeMapping imported = null;
            if (importMapping instanceof NodeMappingImport) {
                imported = ((NodeMappingImport)importMapping).getImportedMapping();
            } else if (importMapping instanceof ContainerMappingImport) {
                imported = ((ContainerMappingImport)importMapping).getImportedMapping();
            }
            if (imported == null) continue;
            result.remove((Object)imported);
        }
        return result;
    }

    public static boolean refreshDiagram(DDiagram diagram_p) {
        boolean result = false;
        if (diagram_p != null) {
            DialectManager.INSTANCE.refresh((DRepresentation)diagram_p, (IProgressMonitor)new NullProgressMonitor());
            result = true;
        }
        return result;
    }
}

