/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.amalgam.explorer.activity.ui.api.editor.pages;

import java.text.MessageFormat;
import org.eclipse.amalgam.explorer.activity.ui.ActivityExplorerActivator;
import org.eclipse.amalgam.explorer.activity.ui.api.editor.predicates.IPredicate;
import org.eclipse.amalgam.explorer.activity.ui.internal.extension.point.manager.ActivityExplorerExtensionManager;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IOrdered;
import org.eclipse.amalgam.explorer.activity.ui.internal.intf.IVisibility;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.activities.WorkbenchActivityHelper;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.editor.SharedHeaderFormEditor;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class CommonActivityExplorerPage
extends FormPage
implements IExecutableExtension,
IOrdered,
IVisibility,
IPropertyListener,
IPluginContribution {
    private boolean overview;
    private Image overviewImageOff;
    private String overviewText;
    private Image overviewImageOn;
    private String overviewImageOnPath;
    private String overviewImageOffPath;
    protected IPredicate predicate;
    protected String pluginId;
    public static final int PROP_ACTIVE = 389;
    private int index;
    private static String ids;

    public static void setID(String id) {
        ids = id;
    }

    public CommonActivityExplorerPage() {
        this(null, ids, "");
    }

    public CommonActivityExplorerPage(FormEditor editor, String id, String title) {
        super(editor, id, title);
    }

    protected void createFormContent(IManagedForm managedForm) {
        FormToolkit toolkit = managedForm.getToolkit();
        toolkit.decorateFormHeading(managedForm.getForm().getForm());
        this.getEditor().addPropertyListener((IPropertyListener)this);
    }

    public SharedHeaderFormEditor getEditor() {
        return (SharedHeaderFormEditor)super.getEditor();
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        super.setInitializationData(cfig, propertyName, data);
        String title = ActivityExplorerExtensionManager.getTitle(cfig);
        String tabName = ActivityExplorerExtensionManager.getTabName(cfig);
        if (tabName == null) {
            tabName = title;
        }
        this.setPartName(tabName);
        boolean bl = this.overview = ActivityExplorerExtensionManager.getOverviewElement(cfig) != null;
        if (this.overview) {
            this.overviewImageOffPath = ActivityExplorerExtensionManager.getOverviewImageOff(cfig);
            this.overviewImageOnPath = ActivityExplorerExtensionManager.getOverviewImageOn(cfig);
            String plugin_id = ActivityExplorerExtensionManager.getPluginId(cfig);
            if (this.overviewImageOffPath.equals("icons/full/overview/logo_off.png")) {
                plugin_id = ActivityExplorerActivator.ID;
            }
            this.setOverviewImageOff(ActivityExplorerActivator.getDefault().getImage(plugin_id, this.overviewImageOffPath));
            if (this.overviewImageOnPath.equals("icons/full/overview/logo_on.png")) {
                plugin_id = ActivityExplorerActivator.ID;
            }
            this.setOverviewImageOn(ActivityExplorerActivator.getDefault().getImage(plugin_id, this.overviewImageOnPath));
            this.setOverViewText(ActivityExplorerExtensionManager.getOverviewDescription(cfig));
            this.pluginId = cfig.getContributor().getName();
        }
        this.predicate = ActivityExplorerExtensionManager.getPredicate(cfig);
        String indice = ActivityExplorerExtensionManager.getIndex(cfig);
        try {
            this.setIndex(Integer.parseInt(indice));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(MessageFormat.format("Attribute ''{0}'' of page {1} must be an int, but was ''{2}''", "index", ActivityExplorerExtensionManager.getId(cfig), indice));
        }
    }

    private void setOverviewImageOn(Image image) {
        this.overviewImageOn = image;
    }

    public String getOverViewImageOnPath() {
        return this.overviewImageOnPath;
    }

    public String getOverViewImageOffPath() {
        return this.overviewImageOffPath;
    }

    public Image getOverViewImageOn() {
        return this.overviewImageOn;
    }

    private void setOverViewText(String text) {
        this.overviewText = text;
    }

    public String getOverViewText() {
        return this.overviewText;
    }

    private void setOverviewImageOff(Image image) {
        this.overviewImageOff = image;
    }

    public Image getOverviewImageOff() {
        return this.overviewImageOff;
    }

    public boolean contributeToOverview() {
        return this.overview;
    }

    public void contributeToOverview(boolean contribute) {
        this.overview = contribute;
    }

    @Override
    public boolean isVisible() {
        boolean result = ActivityExplorerActivator.getDefault().getPreferenceStore().getBoolean(this.getId());
        result &= !WorkbenchActivityHelper.filterItem((Object)this);
        if (this.predicate != null) {
            result &= this.predicate.isPageOk(this);
        }
        return result;
    }

    @Override
    public int getPosition() {
        return this.index;
    }

    @Override
    public void setPosition(int index) {
        this.index = index;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public int compareTo(IOrdered arg0) {
        int result = 1;
        if (arg0 != null) {
            result = new Integer(this.getPosition()).compareTo(new Integer(arg0.getPosition()));
        }
        return result;
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active) {
            this.markAsActive();
        }
    }

    public void propertyChanged(Object source, int propId) {
        if (257 == propId) {
            this.markAsDirty();
        }
    }

    public void markAsDirty() {
        this.firePropertyChange(257);
    }

    public void markAsActive() {
        this.firePropertyChange(389);
    }

    public String getLocalId() {
        return this.getId();
    }

    public String getPluginId() {
        return this.pluginId;
    }
}

