/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.project;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.polarsys.kitalpha.ad.services.manager.ViewpointActivationException;
import org.polarsys.kitalpha.ad.services.manager.ViewpointManager;
import org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.ViewpointFactory;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.desc.helper.configuration.VpDslConfigurationHelper;
import org.polarsys.kitalpha.ad.viewpoint.dsl.as.model.vpdesc.Viewpoint;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.af.integration.AFIntegrationManager;
import org.polarsys.kitalpha.ad.viewpoint.dsl.generation.provider.resourceimpl.ViewpointResourceProviderRegistry;
import org.polarsys.kitalpha.ad.viewpoint.ui.wizard.ProjectHelper;
import org.polarsys.kitalpha.resourcereuse.model.Location;
import org.polarsys.kitalpha.resourcereuse.model.Resource;

public class AfProjectManager {
    public static AfProjectManager INSTANCE = new AfProjectManager();
    private org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint _vp = null;
    private String _vpURI = "";
    private IProject _project = null;
    protected String _vpName = "";
    protected String _viewpointShortName = "";
    protected String _viewpointId = "";
    protected String _vpuuid = "";
    private Map<String, String> _javaRulesClasses = new HashMap<String, String>();

    public void unloadResource() {
        this._vp = null;
        this._project = null;
        this._vpURI = "";
    }

    public org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint getViewpoint() {
        return this._vp;
    }

    public void setViewpoint(org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint viewpoint) {
        this._vp = viewpoint;
        AFIntegrationManager.getInstance().setViewpoint(this._vp);
    }

    public IProject getProject() {
        return this._project;
    }

    public void setProject(IProject project) {
        this._project = project;
    }

    public void registerJavaRule(String id, String clazz) {
        this._javaRulesClasses.put(id, clazz);
    }

    public IProject createProject(String projectName, String vpName, String viewpointShortName, String viewpointId, IProgressMonitor monitor) throws CoreException, IOException {
        this._vpName = vpName;
        this._viewpointShortName = viewpointShortName;
        this._viewpointId = viewpointId;
        String afProjectName = String.valueOf(projectName) + ".af";
        if (monitor != null) {
            monitor.beginTask("Creating artifacts for extension " + afProjectName, 4);
        }
        this._vpURI = String.valueOf('/') + afProjectName + "/model/" + viewpointShortName + ".vp";
        org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint viewpoint = this.createOrGetAFViewpoint(viewpointId, vpName, viewpointShortName);
        IProject afProject = ResourcesPlugin.getWorkspace().getRoot().getProject(afProjectName);
        if (!afProject.exists()) {
            afProject = ProjectHelper.createProject((String)afProjectName, (String)vpName, (String)viewpointId, (String)this._vpuuid, (String)this._vpURI, (IProgressMonitor)monitor);
        }
        if (monitor != null) {
            monitor.done();
        }
        this.setViewpoint(viewpoint);
        this.setProject(afProject);
        return afProject;
    }

    private org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint createOrGetAFViewpoint(String viewpointID, String vpName, String viewpointShortName) throws CoreException {
        org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint viewpoint = null;
        viewpoint = this.getExistingViewpoint(viewpointID);
        if (viewpoint == null) {
            viewpoint = this.createAFModel(vpName, viewpointID);
        }
        return viewpoint;
    }

    private org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint getExistingViewpoint(String viewpointID) {
        Resource[] viewpoints;
        Resource[] resourceArray = viewpoints = ViewpointManager.getAvailableViewpoints();
        int n = viewpoints.length;
        int n2 = 0;
        while (n2 < n) {
            EObject root;
            String pluginID;
            String resourcePath;
            URI uri;
            ResourceSetImpl set;
            org.eclipse.emf.ecore.resource.Resource vpResource;
            Resource resource = resourceArray[n2];
            if (resource.getId().equals(viewpointID) && resource.getProviderLocation().equals((Object)Location.WORSPACE) && (vpResource = (set = new ResourceSetImpl()).getResource(uri = URI.createURI((String)(resourcePath = "platform:/resource" + (pluginID = resource.getPath().substring(0, resource.getPath().indexOf("#")))), (boolean)false), true)).getContents() != null && vpResource.getContents().size() > 0 && (root = (EObject)vpResource.getContents().get(0)) instanceof org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint) {
                org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint viewpoint = (org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint)root;
                this._vpuuid = viewpoint.getVpid();
                return viewpoint;
            }
            ++n2;
        }
        return null;
    }

    private org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint createAFModel(String vpName, String viewpointID) throws CoreException {
        org.polarsys.kitalpha.ad.viewpoint.coredomain.viewpoint.model.Viewpoint vp = ViewpointFactory.eINSTANCE.createViewpoint();
        vp.setId(viewpointID);
        vp.setName(vpName);
        this._vpuuid = EcoreUtil.generateUUID();
        vp.setVpid(this._vpuuid);
        return vp;
    }

    public void saveModel() throws CoreException, ViewpointActivationException {
        WorkspaceModifyOperation saveOperation = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
                org.eclipse.emf.ecore.resource.Resource vpResource = AfProjectManager.this._vp.eResource();
                if (vpResource == null) {
                    ResourceSetImpl set = new ResourceSetImpl();
                    URI uri = URI.createPlatformResourceURI((String)AfProjectManager.this._vpURI, (boolean)false);
                    vpResource = set.createResource(uri);
                    vpResource.getContents().add((Object)AfProjectManager.this._vp);
                }
                if (vpResource != null) {
                    try {
                        vpResource.save(Collections.EMPTY_MAP);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Can not save resource", e);
                    }
                }
            }
        };
        try {
            saveOperation.run(null);
            ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, null);
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void regenerateBuildProperties(String projectName) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile xml = project.getFile("build.properties");
        StringBuffer contents = new StringBuffer();
        contents.append("source.. = src/\n");
        contents.append("output.. = bin/\n");
        contents.append("bin.includes = META-INF/,\\\n");
        contents.append("               .,\\\n");
        contents.append("               model/,\\\n");
        contents.append("               icons/,\\\n");
        contents.append("               plugin.xml\n");
        try {
            xml.setContents((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), 0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    public void regeneratePluginXML(String projectName) {
        this._vpURI = String.valueOf('/') + projectName + "/model/" + this._viewpointShortName + ".vp";
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        IFile xml = project.getFile("plugin.xml");
        StringBuffer contents = new StringBuffer();
        boolean isVisible = this.isVisibleViewpoint();
        boolean isActivable = this.isActivableViewpoint();
        contents.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        contents.append("<?eclipse version=\"3.4\"?>\n");
        contents.append("<plugin>\n");
        contents.append("\t<extension\n");
        contents.append("\t     point=\"org.eclipse.ui.views\">\n");
        contents.append("\t  <view\n");
        contents.append("\t        name=\"").append(this._vpName).append("\"\n");
        contents.append("\t        icon=\"icons/view.gif\"\n");
        contents.append("\t        category=\"org.polarsys.kitalpha.view.category\"\n");
        contents.append("\t        class=\"org.polarsys.kitalpha.ad.viewpoint.ui.views.ViewpointView\"\n");
        contents.append("\t        id=\"").append(this._viewpointId).append(".view\"\n");
        contents.append("\t        resourceId=\"").append(this._viewpointId).append("\"/>\n");
        contents.append("\t</extension>\n");
        contents.append("\t<extension\n");
        contents.append("\t     point=\"org.polarsys.kitalpha.resourcereuse.resources\">\n");
        contents.append("\t  <resource\n");
        contents.append("\t        domain=\"AF\"\n");
        contents.append("\t        id=\"").append(this._viewpointId).append("\"\n");
        contents.append("\t        tags=\"vp");
        if (!isVisible) {
            contents.append(",").append("stateHidden");
        }
        if (isActivable) {
            contents.append(",").append("stateMutableActivation");
        }
        contents.append("\"\n");
        contents.append("\t        name=\"").append(this._vpName).append("\"\n");
        contents.append("\t        path=\"").append(this._vpURI).append('#').append(this._vpuuid).append("\"/>\n");
        contents.append("\t</extension>\n");
        contents.append("\t<extension \n");
        contents.append("\t     point=\"org.eclipse.ui.propertiesView\">\n");
        contents.append("\t \t<excludeSources\n");
        contents.append("\t    \tid=\"").append(this._viewpointId).append(".view\">\n");
        contents.append("\t \t</excludeSources>\n");
        contents.append("\t</extension>\n");
        for (String iJavaRuleClass : this._javaRulesClasses.keySet()) {
            contents.append("\t<extension\n");
            contents.append("\t\tpoint=\"org.polarsys.kitalpha.ad.viewpoint.javarules\">\n");
            contents.append("\t\t<JavaRule\n");
            contents.append("\t\t\tname=\"" + iJavaRuleClass + "\"\n");
            contents.append("\t\t\tclass=\"" + this._javaRulesClasses.get(iJavaRuleClass).toString() + "\">\n");
            contents.append("\t\t</JavaRule>\n");
            contents.append("\t</extension>\n");
        }
        contents.append("</plugin>\n");
        contents.append("\n");
        try {
            if (!xml.exists()) {
                xml.create((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), 0, null);
            } else {
                xml.setContents((InputStream)new ByteArrayInputStream(contents.toString().getBytes()), 0, null);
            }
            xml.refreshLocal(0, null);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean isVisibleViewpoint() {
        Viewpoint viewpoint = ViewpointResourceProviderRegistry.getInstance().getViewpoint();
        return VpDslConfigurationHelper.getViewpointVisibility((Object)viewpoint);
    }

    private boolean isActivableViewpoint() {
        Viewpoint viewpoint = ViewpointResourceProviderRegistry.getInstance().getViewpoint();
        return VpDslConfigurationHelper.isActivableViewpoint((Object)viewpoint);
    }
}

