/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.handler.command;

import java.util.Collection;
import java.util.Collections;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.polarsys.capella.core.model.handler.command.DeleteCommand;
import org.polarsys.capella.core.model.handler.command.IDeleteHelper;

public class DeleteStructureCommand
extends DeleteCommand {
    public DeleteStructureCommand(EditingDomain editingDomain, Collection<?> elements) {
        super(editingDomain, elements);
    }

    @Override
    protected void deletePointingReference(EObject referencingEObject, EStructuralFeature feature, EObject referenceToDelete) {
        super.deletePointingReference(referencingEObject, feature, referenceToDelete);
        this.deleteSemanticStructure(referenceToDelete, referencingEObject, feature);
    }

    protected void deleteSemanticStructure(EObject linkObject, EObject sourceObject, EStructuralFeature feature) {
        Collection<Command> additionnalCommands;
        IDeleteHelper helper = IDeleteHelper.DEFAULT;
        if (helper.isDeleteSemanticStructure(sourceObject, linkObject, feature)) {
            this.appendAndExecute(this.doDeleteStructure(sourceObject));
        } else if (helper.isDeleteElement(sourceObject, linkObject, feature)) {
            this.appendAndExecute(this.doDeleteElement(sourceObject));
        }
        Collection<EObject> additionnalElements = helper.getAdditionalElements(sourceObject, linkObject, feature);
        if (additionnalElements != null) {
            for (EObject object : additionnalElements) {
                this.appendAndExecute(this.doDeleteStructure(object));
            }
        }
        if (this.runAdditionalCommands() && (additionnalCommands = helper.getAdditionalCommands(sourceObject, linkObject, feature)) != null) {
            for (Command object : additionnalCommands) {
                this.appendAndExecute(object);
            }
        }
    }

    protected boolean runAdditionalCommands() {
        return true;
    }

    protected Command doDeleteElement(EObject sourceObject) {
        return new DeleteCommand(this.getEditingDomain(), Collections.singletonList(sourceObject));
    }

    protected Command doDeleteStructure(EObject sourceObject) {
        return new DeleteStructureCommand(this.getEditingDomain(), Collections.singletonList(sourceObject));
    }
}

