/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.platform.sirius.ui.navigator.view;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.internal.navigator.CommonNavigatorActionGroup;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.LinkHelperService;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.QuickFiltersMenu;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SearchMenu;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.SelectionHelper;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveDownAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.move.MoveUpAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.view.CapellaCommonNavigator;

public class CapellaCommonNavigatorActionGroup
extends CommonNavigatorActionGroup {
    CapellaCommonNavigator navigator;
    private MoveDownAction moveDownAction;
    private MoveUpAction moveUpAction;
    private QuickFiltersMenu quickFiltersMenu;
    private SearchMenu searchMenu;

    public CapellaCommonNavigatorActionGroup(CapellaCommonNavigator aNavigator, CommonViewer aViewer, LinkHelperService linkHelperService) {
        super((CommonNavigator)aNavigator, aViewer, linkHelperService);
        this.navigator = aNavigator;
        ISelectionProvider selectionProvider = this.navigator.getViewSite().getSelectionProvider();
        this.moveUpAction = new MoveUpAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveUpAction, selectionProvider);
        this.moveDownAction = new MoveDownAction();
        SelectionHelper.registerToSelectionChanges((ISelectionChangedListener)this.moveDownAction, selectionProvider);
        IStructuredSelection selection = (IStructuredSelection)selectionProvider.getSelection();
        this.moveUpAction.selectionChanged(selection);
        this.moveDownAction.selectionChanged(selection);
        this.quickFiltersMenu = new QuickFiltersMenu(this.navigator);
        this.searchMenu = new SearchMenu(this.navigator);
    }

    protected void fillToolBar(IToolBarManager toolBar) {
        toolBar.add((IAction)this.moveUpAction);
        toolBar.add((IAction)this.moveDownAction);
        toolBar.add((IContributionItem)new Separator());
        super.fillToolBar(toolBar);
    }

    protected void fillViewMenu(IMenuManager menu) {
        menu.insertBefore("additions", (IContributionItem)this.quickFiltersMenu);
        super.fillViewMenu(menu);
        menu.add((IContributionItem)new Separator());
        menu.add((IContributionItem)this.searchMenu);
    }

    public void dispose() {
        super.dispose();
        ISelectionProvider selectionProvider = this.navigator.getViewSite().getSelectionProvider();
        if (this.moveUpAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveUpAction);
            this.moveUpAction = null;
        }
        if (this.moveDownAction != null) {
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.moveDownAction);
            this.moveDownAction = null;
        }
        this.quickFiltersMenu.dispose();
        this.searchMenu.dispose();
    }
}

