/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.query.legacy.tools.resources;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.sirius.query.legacy.tools.AcceleoToolsMessages;
import org.eclipse.sirius.query.legacy.tools.AcceleoToolsPlugin;
import org.eclipse.sirius.query.legacy.tools.log.AcceleoException;

public abstract class AcceleoPlugin
extends Plugin {
    public abstract String getID();

    public void log(IStatus status) {
        this.getLog().log(status);
        AcceleoToolsPlugin.getDefault().newAcceleoLog(status);
    }

    public void log(Throwable e, boolean blocker) {
        if (e instanceof CoreException) {
            IStatus status = ((CoreException)e).getStatus();
            this.log((IStatus)new Status(status.getSeverity(), this.getID(), status.getCode(), status.getMessage(), status.getException()));
        } else if (e instanceof InvocationTargetException) {
            this.log(((InvocationTargetException)e).getTargetException(), blocker);
        } else if (e instanceof AcceleoException) {
            int severity = blocker ? 4 : 2;
            this.log((IStatus)new Status(severity, this.getID(), severity, e.getMessage() != null ? e.getMessage() : AcceleoToolsMessages.getString("AcceleoPlugin.UnknownError"), null));
        } else if (e instanceof NullPointerException) {
            int severity = blocker ? 4 : 2;
            this.log((IStatus)new Status(severity, this.getID(), severity, AcceleoToolsMessages.getString("AcceleoPlugin.MissingElement"), e));
        } else {
            int severity = blocker ? 4 : 2;
            this.log((IStatus)new Status(severity, this.getID(), severity, AcceleoToolsMessages.getString("AcceleoPlugin.UnexpectedException"), e));
        }
    }

    public void log(String message, boolean blocker) {
        int severity = blocker ? 4 : 2;
        this.log((IStatus)new Status(severity, this.getID(), severity, message != null ? message.trim().replaceFirst("\n", ";\n") : AcceleoToolsMessages.getString("AcceleoPlugin.UnknownError"), null));
    }
}

