/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.data.core.ui.quickfix.resolver;

import java.util.Map;
import java.util.Optional;
import org.eclipse.core.resources.IMarker;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.common.ef.command.ICommand;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.common.tools.report.appenders.reportlogview.MarkerViewHelper;
import org.polarsys.capella.core.data.common.validation.project.UnkownFeaturesRule;
import org.polarsys.capella.core.data.information.InformationFactory;
import org.polarsys.capella.core.data.information.Unit;
import org.polarsys.capella.core.validation.ui.ide.quickfix.AbstractCapellaMarkerResolution;

public class I_44_Resolver
extends AbstractCapellaMarkerResolution {
    public void run(IMarker marker) {
        Optional<UnkownFeaturesRule.UnknownFeatureData> unknownFeatureData = this.extractUnknownFeatureData(marker);
        if (unknownFeatureData.isPresent()) {
            boolean featureRemoved;
            FeatureMap attributeMap;
            UnkownFeaturesRule.UnknownFeatureData data = unknownFeatureData.get();
            Map objectToExtensionMap = data.resource.getEObjectToExtensionMap();
            AnyType anyType = (AnyType)objectToExtensionMap.get(data.modelElement);
            if (anyType != null && (attributeMap = anyType.getAnyAttribute()) != null && (featureRemoved = attributeMap.removeIf(entry -> unknownFeatureData.unknownFeature.equals(entry.getEStructuralFeature())))) {
                this.setResourceDirty((Resource)data.resource);
                this.deleteMarker(marker);
            }
        }
    }

    private Optional<UnkownFeaturesRule.UnknownFeatureData> extractUnknownFeatureData(IMarker marker) {
        return MarkerViewHelper.getModelElementsFromMarker((IMarker)marker).stream().filter(UnkownFeaturesRule.UnknownFeatureData.class::isInstance).map(UnkownFeaturesRule.UnknownFeatureData.class::cast).findAny();
    }

    private void setResourceDirty(final Resource resource) {
        TransactionHelper.getExecutionManager((Resource)resource).execute((ICommand)new AbstractReadWriteCommand(){

            public void run() {
                EList contents = resource.getContents();
                int lastIndex = contents.size();
                Unit lightDummy = InformationFactory.eINSTANCE.createUnit();
                contents.add((Object)lightDummy);
                contents.remove(lastIndex);
            }
        });
    }
}

