/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.skeleton.impl.cmd;

import org.polarsys.capella.common.data.modellingcore.AbstractType;
import org.polarsys.capella.common.data.modellingcore.TraceableElement;
import org.polarsys.capella.common.ef.command.AbstractReadWriteCommand;
import org.polarsys.capella.core.data.capellacommon.AbstractCapabilityPkg;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.CsFactory;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.epbs.ConfigurationItem;
import org.polarsys.capella.core.data.epbs.ConfigurationItemKind;
import org.polarsys.capella.core.data.epbs.ConfigurationItemPkg;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.epbs.EpbsFactory;
import org.polarsys.capella.core.data.epbs.PhysicalArchitectureRealization;
import org.polarsys.capella.core.data.epbs.PhysicalArtifactRealization;
import org.polarsys.capella.core.data.la.CapabilityRealizationPkg;
import org.polarsys.capella.core.data.la.LaFactory;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.data.pa.PhysicalComponent;
import org.polarsys.capella.core.model.helpers.naming.NamingConstants;
import org.polarsys.capella.core.model.skeleton.Messages;

public class CreateEPBSArchiCmd
extends AbstractReadWriteCommand {
    private String architectureName;
    private EPBSArchitecture epbsArchitecture;
    private PhysicalArchitecture physicalArchitecture;
    private SystemEngineering systemEng;
    private PhysicalComponent pcRoot;

    public CreateEPBSArchiCmd(SystemEngineering systemEng, String architectureName, PhysicalArchitecture physicalArchitecture, PhysicalComponent physicalComp) {
        this.architectureName = architectureName;
        this.physicalArchitecture = physicalArchitecture;
        this.systemEng = systemEng;
        this.pcRoot = physicalComp;
    }

    public CreateEPBSArchiCmd(SystemEngineering systemEng, String architectureName, PhysicalArchitecture physicalArchitecture, PhysicalComponent physicalComp, EPBSArchitecture createdElement) {
        this(systemEng, architectureName, physicalArchitecture, physicalComp);
        this.epbsArchitecture = createdElement;
    }

    public void run() {
        if (this.epbsArchitecture == null) {
            this.epbsArchitecture = EpbsFactory.eINSTANCE.createEPBSArchitecture();
            this.systemEng.getOwnedArchitectures().add((Object)this.epbsArchitecture);
        }
        this.epbsArchitecture.setName(this.architectureName);
        ConfigurationItemPkg cipkg = EpbsFactory.eINSTANCE.createConfigurationItemPkg(NamingConstants.CreateEPBSArchCmd_configurationItemPkg_name);
        this.epbsArchitecture.setOwnedConfigurationItemPkg(cipkg);
        ConfigurationItem ci = EpbsFactory.eINSTANCE.createConfigurationItem(NamingConstants.CreateEPBSArchCmd_configurationItem_name);
        ci.setKind(ConfigurationItemKind.SYSTEM_CI);
        cipkg.getOwnedConfigurationItems().add((Object)ci);
        Part epbsRootPart = CsFactory.eINSTANCE.createPart(ci.getName());
        cipkg.getOwnedParts().add((Object)epbsRootPart);
        epbsRootPart.setAbstractType((AbstractType)ci);
        if (this.pcRoot != null) {
            PhysicalArtifactRealization physicalComponentRealisation = EpbsFactory.eINSTANCE.createPhysicalArtifactRealization();
            ci.getOwnedPhysicalArtifactRealizations().add((Object)physicalComponentRealisation);
            physicalComponentRealisation.setSourceElement((TraceableElement)ci);
            physicalComponentRealisation.setTargetElement((TraceableElement)this.pcRoot);
        }
        if (this.physicalArchitecture != null) {
            PhysicalArchitectureRealization physicalArchitectureAlloc = EpbsFactory.eINSTANCE.createPhysicalArchitectureRealization();
            this.epbsArchitecture.getOwnedPhysicalArchitectureRealizations().add((Object)physicalArchitectureAlloc);
            physicalArchitectureAlloc.setSourceElement((TraceableElement)this.epbsArchitecture);
            physicalArchitectureAlloc.setTargetElement((TraceableElement)this.physicalArchitecture);
        }
        CapabilityRealizationPkg capaRealisationPkg = LaFactory.eINSTANCE.createCapabilityRealizationPkg(NamingConstants.CreateCommonCmd_capability_realisation_pkg_name);
        this.epbsArchitecture.setOwnedAbstractCapabilityPkg((AbstractCapabilityPkg)capaRealisationPkg);
    }

    public EPBSArchitecture getEPBSArchitecture() {
        return this.epbsArchitecture;
    }

    public PhysicalArchitecture getPhysicalArchitecture() {
        return this.physicalArchitecture;
    }

    public String getName() {
        return Messages.getString("capella.epbs_archi.create.cmd");
    }
}

