/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers;

import java.util.ArrayList;
import java.util.List;
import org.polarsys.capella.core.data.capellacore.Classifier;
import org.polarsys.capella.core.data.capellacore.Structure;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.ComponentArchitecture;
import org.polarsys.capella.core.data.cs.Interface;
import org.polarsys.capella.core.data.cs.InterfacePkg;
import org.polarsys.capella.core.data.information.Class;
import org.polarsys.capella.core.data.information.DataPkg;
import org.polarsys.capella.core.data.information.Service;
import org.polarsys.capella.core.data.information.communication.Exception;
import org.polarsys.capella.core.data.information.communication.Message;
import org.polarsys.capella.core.data.information.communication.MessageReference;
import org.polarsys.capella.core.data.la.LogicalComponent;
import org.polarsys.capella.core.model.helpers.ClassExt;
import org.polarsys.capella.core.model.helpers.DataPkgExt;
import org.polarsys.capella.core.model.helpers.InterfaceExt;
import org.polarsys.capella.core.model.helpers.InterfacePkgExt;
import org.polarsys.capella.core.model.helpers.StructureExt;

public class ServiceExt {
    public static List<Exception> getExceptionsFromRootComponentArchitecture(Service service) {
        ArrayList<Exception> list = new ArrayList<Exception>();
        Structure rootPkg = ServiceExt.getRootOwnerPkg(service);
        if (rootPkg != null) {
            ComponentArchitecture compArch = StructureExt.getRootComponentArchitecture(rootPkg);
            list.addAll(ServiceExt.getExceptionsFromComponentArchitecture(compArch));
        }
        return list;
    }

    public static List<Message> getMessageFromRootComponentArchitecture(Service service) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        Structure rootPkg = ServiceExt.getRootOwnerPkg(service);
        if (rootPkg != null) {
            ComponentArchitecture compArch = StructureExt.getRootComponentArchitecture(rootPkg);
            list.addAll(ServiceExt.getMessagesFromComponentArchitecture(compArch));
        }
        return list;
    }

    public static ComponentArchitecture getRootComponentArchitecture(Service service) {
        ComponentArchitecture root = null;
        Structure rootPkg = ServiceExt.getRootOwnerPkg(service);
        if (rootPkg != null) {
            root = StructureExt.getRootComponentArchitecture(rootPkg);
        }
        return root;
    }

    public static List<Message> getMessagesFromComponentArchitecture(ComponentArchitecture compArch) {
        DataPkg dataPkg;
        ArrayList<Message> list = new ArrayList<Message>(1);
        if (compArch != null && (dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch)) != null) {
            list.addAll(DataPkgExt.getAllMessages(dataPkg));
        }
        return list;
    }

    public static List<Exception> getExceptionsFromComponentArchitecture(ComponentArchitecture compArch) {
        DataPkg dataPkg;
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        if (compArch != null && (dataPkg = DataPkgExt.getDataPkgOfComponentArchitecture(compArch)) != null) {
            list.addAll(DataPkgExt.getAllExceptions(dataPkg));
        }
        return list;
    }

    public static List<Message> getMessageFromRootComponent(Service service) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        Component parentComp = ServiceExt.getRootComponent(service);
        if (parentComp != null) {
            list.addAll(ServiceExt.getMessagesFromComponent(parentComp));
        }
        return list;
    }

    public static List<Exception> getExceptionsFromRootComponent(Service service) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        Component parentComp = ServiceExt.getRootComponent(service);
        if (parentComp != null) {
            list.addAll(ServiceExt.getExceptionsFromComponent(parentComp));
        }
        return list;
    }

    public static List<Message> getMessagesFromComponent(Component component) {
        DataPkg dataPkg;
        ArrayList<Message> list = new ArrayList<Message>(1);
        if (component != null && component instanceof LogicalComponent && (dataPkg = ((LogicalComponent)component).getOwnedDataPkg()) != null) {
            list.addAll(DataPkgExt.getAllMessages(dataPkg));
        }
        return list;
    }

    public static List<Exception> getExceptionsFromComponent(Component component) {
        DataPkg dataPkg;
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        if (component != null && component instanceof LogicalComponent && (dataPkg = ((LogicalComponent)component).getOwnedDataPkg()) != null) {
            list.addAll(DataPkgExt.getAllExceptions(dataPkg));
        }
        return list;
    }

    public static boolean isReferencing(Service service, Message message) {
        for (MessageReference ref : service.getMessageReferences()) {
            if (!ref.getMessage().equals(message)) continue;
            return true;
        }
        return false;
    }

    public static boolean isThrowing(Service service, Exception exception) {
        if (service != null) {
            return service.getThrownExceptions().contains((Object)exception);
        }
        return false;
    }

    public static List<Message> getFilteredMessages(Service currentService, List<Message> messageList) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        for (Message message : messageList) {
            if (ServiceExt.isReferencing(currentService, message)) continue;
            list.add(message);
        }
        return list;
    }

    public static List<Exception> getFilteredExceptions(Service currentService, List<Exception> exceptionList) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        for (Exception exception : exceptionList) {
            if (ServiceExt.isThrowing(currentService, exception)) continue;
            list.add(exception);
        }
        return list;
    }

    public static List<Message> getMessagesFromParentHierarchy(Service currentService) {
        ArrayList<Message> list = new ArrayList<Message>(1);
        Classifier owningClass = (Classifier)currentService.eContainer();
        if (owningClass instanceof Class) {
            DataPkg rootClassPkg = ClassExt.getRootOwnerDataPkg((Class)owningClass);
            list.addAll(DataPkgExt.getMessagesFromParentHierarchy(rootClassPkg));
        } else if (owningClass instanceof Interface) {
            InterfacePkg rootInterfacePkg = InterfaceExt.getRootOwnerInterfacePkg((Interface)owningClass);
            list.addAll(DataPkgExt.getMessagesFromParentHierarchy(rootInterfacePkg));
        }
        return list;
    }

    public static List<Exception> getExceptionsFromParentHierarchy(Service currentService) {
        ArrayList<Exception> list = new ArrayList<Exception>(1);
        Classifier owningClass = (Classifier)currentService.eContainer();
        if (owningClass instanceof Class) {
            DataPkg rootClassPkg = ClassExt.getRootOwnerDataPkg((Class)owningClass);
            list.addAll(DataPkgExt.getExceptionsFromParentHierarchy(rootClassPkg));
        } else if (owningClass instanceof Interface) {
            InterfacePkg rootInterfacePkg = InterfaceExt.getRootOwnerInterfacePkg((Interface)owningClass);
            list.addAll(DataPkgExt.getExceptionsFromParentHierarchy(rootInterfacePkg));
        }
        return list;
    }

    private static Structure getRootOwnerPkg(Service service) {
        DataPkg rootPkg = null;
        Classifier owningClass = (Classifier)service.eContainer();
        if (owningClass instanceof Class) {
            rootPkg = ClassExt.getRootOwnerDataPkg((Class)owningClass);
        } else if (owningClass instanceof Interface) {
            rootPkg = InterfaceExt.getRootOwnerInterfacePkg((Interface)owningClass);
        }
        return rootPkg;
    }

    private static Component getRootComponent(Service service) {
        Component rootCpnt = null;
        Classifier owningClass = (Classifier)service.eContainer();
        if (owningClass instanceof Class) {
            DataPkg rootClassPkg = ClassExt.getRootOwnerDataPkg((Class)owningClass);
            rootCpnt = DataPkgExt.getRootComponent(rootClassPkg);
        } else if (owningClass instanceof Interface) {
            InterfacePkg rootInterfacePkg = InterfaceExt.getRootOwnerInterfacePkg((Interface)owningClass);
            rootCpnt = InterfacePkgExt.getRootComponent(rootInterfacePkg);
        }
        return rootCpnt;
    }
}

