/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.model.helpers.graph;

import java.util.Arrays;
import java.util.Collection;
import org.polarsys.capella.common.helpers.EObjectLabelProviderHelper;
import org.polarsys.capella.core.model.helpers.graph.GraphNode;

public class GraphEdge<ES, N extends GraphNode> {
    protected ES semantic;
    protected N source;
    protected N target;

    public GraphEdge(ES semantic) {
        this.semantic = semantic;
    }

    public ES getSemantic() {
        return this.semantic;
    }

    public N getSource() {
        return this.source;
    }

    public N getTarget() {
        return this.target;
    }

    public Collection<N> getConnectedNodes() {
        return Arrays.asList(this.source, this.target);
    }

    public void setSource(N newSource) {
        if (this.source != null) {
            ((GraphNode)this.source).outgoingEdges.remove(this);
        }
        this.source = newSource;
        if (this.source != null) {
            ((GraphNode)this.source).outgoingEdges.add(this);
        }
    }

    public void setTarget(N newTarget) {
        if (this.target != null) {
            ((GraphNode)this.target).incomingEdges.remove(this);
        }
        this.target = newTarget;
        if (this.target != null) {
            ((GraphNode)this.target).incomingEdges.add(this);
        }
    }

    public String toString() {
        return "e(" + EObjectLabelProviderHelper.getText(this.semantic) + ")";
    }
}

