/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.queries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.polarsys.capella.common.helpers.TransactionHelper;
import org.polarsys.capella.core.data.capellamodeller.ModelRoot;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.capellamodeller.SystemEngineering;
import org.polarsys.capella.core.data.cs.BlockArchitecture;
import org.polarsys.capella.core.data.cs.Component;
import org.polarsys.capella.core.data.cs.Part;
import org.polarsys.capella.core.data.ctx.SystemAnalysis;
import org.polarsys.capella.core.data.epbs.EPBSArchitecture;
import org.polarsys.capella.core.data.la.LogicalArchitecture;
import org.polarsys.capella.core.data.oa.OperationalAnalysis;
import org.polarsys.capella.core.data.pa.PhysicalArchitecture;
import org.polarsys.capella.core.libraries.model.CapellaModel;
import org.polarsys.capella.core.model.helpers.BlockArchitectureExt;
import org.polarsys.capella.core.model.helpers.ComponentExt;
import org.polarsys.capella.core.model.helpers.SystemEngineeringExt;

public class QueryExt {
    public static List<Part> getParts(Component element_p, EClass eClass_p, EClass excludeEClass_p) {
        ArrayList<Part> parts = new ArrayList<Part>();
        for (Part part : ComponentExt.getSubParts((Component)element_p)) {
            if (!(part instanceof Part) || !eClass_p.isInstance((Object)part.getAbstractType()) || excludeEClass_p != null && excludeEClass_p.isInstance((Object)part.getAbstractType())) continue;
            parts.add(part);
        }
        return parts;
    }

    public static SystemEngineering getSystemEngineeringFrom(Project project) {
        SystemEngineering systemEngineering = null;
        Iterator it = project.getOwnedModelRoots().iterator();
        while (systemEngineering == null && it.hasNext()) {
            ModelRoot mr = (ModelRoot)it.next();
            if (!(mr instanceof SystemEngineering)) continue;
            systemEngineering = (SystemEngineering)mr;
        }
        return systemEngineering;
    }

    public static SystemEngineering getSystemEngineeringFromLibrary(TransactionalEditingDomain domain, CapellaModel library) {
        if (library != null) {
            Project libraryProject = library.getProject(domain);
            SystemEngineering systemEngineering = QueryExt.getSystemEngineeringFrom(libraryProject);
            return systemEngineering;
        }
        return null;
    }

    public static BlockArchitecture getCorrespondingBlockArchitectureFromLibrary(BlockArchitecture currentArchBlock, CapellaModel library) {
        OperationalAnalysis res = null;
        Project libraryProject = library.getProject(TransactionHelper.getEditingDomain((EObject)currentArchBlock));
        if (libraryProject != null) {
            SystemEngineering systemEngineering = QueryExt.getSystemEngineeringFrom(libraryProject);
            if (currentArchBlock instanceof OperationalAnalysis) {
                res = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
            } else if (currentArchBlock instanceof SystemAnalysis) {
                res = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering);
            } else if (currentArchBlock instanceof LogicalArchitecture) {
                res = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering);
            } else if (currentArchBlock instanceof PhysicalArchitecture) {
                res = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering);
            } else if (currentArchBlock instanceof EPBSArchitecture) {
                res = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering);
            }
        }
        return res;
    }

    public static BlockArchitecture getBlockArchitectureFromLibraryUpward(BlockArchitecture currentArchBlock, CapellaModel library) {
        OperationalAnalysis res = null;
        Project libraryProject = library.getProject(TransactionHelper.getEditingDomain((EObject)currentArchBlock));
        if (libraryProject != null) {
            SystemEngineering systemEngineering = QueryExt.getSystemEngineeringFrom(libraryProject);
            if (currentArchBlock instanceof OperationalAnalysis) {
                res = SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
            } else if (currentArchBlock instanceof SystemAnalysis) {
                res = QueryExt.getSystemAnalysisFromLibrary(systemEngineering);
            } else if (currentArchBlock instanceof LogicalArchitecture) {
                res = QueryExt.getLogicalArchitectureFromLibrary(systemEngineering);
            } else if (currentArchBlock instanceof PhysicalArchitecture) {
                res = QueryExt.getPhysicalArchitectureFromLibrary(systemEngineering);
            } else if (currentArchBlock instanceof EPBSArchitecture) {
                res = QueryExt.getEPBSArchitectureFromLibrary(systemEngineering);
            }
        }
        return res;
    }

    public static BlockArchitecture getSystemAnalysisFromLibrary(SystemEngineering systemEngineering) {
        Object res = null;
        res = SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering) != null ? SystemEngineeringExt.getOwnedSystemAnalysis((SystemEngineering)systemEngineering) : SystemEngineeringExt.getOwnedOperationalAnalysis((SystemEngineering)systemEngineering);
        return res;
    }

    public static BlockArchitecture getLogicalArchitectureFromLibrary(SystemEngineering systemEngineering) {
        Object res = null;
        res = SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering) != null ? SystemEngineeringExt.getOwnedLogicalArchitecture((SystemEngineering)systemEngineering) : QueryExt.getSystemAnalysisFromLibrary(systemEngineering);
        return res;
    }

    public static BlockArchitecture getPhysicalArchitectureFromLibrary(SystemEngineering systemEngineering) {
        Object res = null;
        res = SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering) != null ? SystemEngineeringExt.getOwnedPhysicalArchitecture((SystemEngineering)systemEngineering) : QueryExt.getLogicalArchitectureFromLibrary(systemEngineering);
        return res;
    }

    public static BlockArchitecture getEPBSArchitectureFromLibrary(SystemEngineering systemEngineering) {
        Object res = null;
        res = SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering) != null ? SystemEngineeringExt.getEPBSArchitecture((SystemEngineering)systemEngineering) : QueryExt.getPhysicalArchitectureFromLibrary(systemEngineering);
        return res;
    }

    public static EObject getCorrespondingElementInLibrary(EObject input, CapellaModel library) {
        BlockArchitecture currentArchBlock = BlockArchitectureExt.getRootBlockArchitecture((EObject)input);
        return QueryExt.getBlockArchitectureFromLibraryUpward(currentArchBlock, library);
    }
}

