/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.explorer.activity.ui.hyperlinkadapter;

import org.eclipse.amalgam.explorer.activity.ui.api.hyperlinkadapter.AbstractNewDiagramHyperlinkAdapter;
import org.eclipse.amalgam.explorer.activity.ui.api.manager.ActivityExplorerManager;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.ui.RefreshEditorsPrecommitListener;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.polarsys.capella.common.libraries.ILibraryManager;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.tools.report.appenders.usage.UsageMonitoringLogger;
import org.polarsys.capella.common.tools.report.appenders.usage.util.UsageMonitoring;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.sirius.ui.actions.NewRepresentationAction;
import org.polarsys.capella.shared.id.handler.IdManager;

public abstract class AbstractCapellaNewDiagramHyperlinkAdapter
extends AbstractNewDiagramHyperlinkAdapter {
    public AbstractCapellaNewDiagramHyperlinkAdapter() {
        super(ActivityExplorerManager.INSTANCE.getRootSemanticModel());
    }

    protected boolean useDefaultName() {
        return false;
    }

    public void linkActivated(HyperlinkEvent event) {
        Session session = ActivityExplorerManager.INSTANCE.getSession();
        RefreshEditorsPrecommitListener repl = session.getRefreshEditorsListener();
        repl.notify(10);
        repl.notify(11);
        IModel model = ILibraryManager.INSTANCE.getModel(session.getTransactionalEditingDomain());
        Project project = ((ICapellaModel)model).getProject(session.getTransactionalEditingDomain());
        String eventName = "Create Representation";
        String eventContext = this.getRepresentationName();
        EObject modelElement = this.getModelElement((EObject)project);
        String addendum = IdManager.getInstance().getId(modelElement);
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.NONE, addendum);
        this.linkPressed(event, modelElement, session);
        UsageMonitoringLogger.getInstance().log(eventName, eventContext, UsageMonitoring.EventStatus.OK, addendum);
    }

    public boolean createDiagram(EObject rootObj, Session session) {
        if (rootObj == null && session == null) {
            return false;
        }
        RepresentationDescription representationDescription = this.getDiagramRepresentation(session, rootObj);
        final NewRepresentationAction action = this.initNewRepresentationAction(rootObj, session, representationDescription);
        RecordingCommand cmd = new RecordingCommand(TransactionUtil.getEditingDomain((EObject)rootObj)){

            protected void doExecute() {
                action.run();
            }
        };
        TransactionUtil.getEditingDomain((EObject)rootObj).getCommandStack().execute((Command)cmd);
        return true;
    }

    protected NewRepresentationAction initNewRepresentationAction(EObject rootObj, Session session, RepresentationDescription representationDescription) {
        return new NewRepresentationAction(representationDescription, rootObj, session, this.useDefaultName(), true);
    }
}

