/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.polarsys.capella.core.ui.properties.richtext.CapellaMDERichTextFactory;
import org.polarsys.kitalpha.richtext.common.intf.MDERichTextWidget;
import org.polarsys.kitalpha.richtext.nebula.widget.MDENebulaBasedRichTextWidget;

public class RichtextManager {
    private static RichtextManager instance;
    private MDENebulaBasedRichTextWidget richtextWidget;
    private Shell invisibleShell = new Shell();

    private RichtextManager() {
    }

    public static RichtextManager getInstance() {
        if (instance == null) {
            instance = new RichtextManager();
        }
        return instance;
    }

    public MDERichTextWidget getRichtextWidget(Composite parent) {
        if (this.richtextWidget == null || this.richtextWidget.isEditorDisposed()) {
            CapellaMDERichTextFactory factory = new CapellaMDERichTextFactory();
            MDERichTextWidget widget = factory.createMinimalRichTextWidget(parent);
            if (widget instanceof MDENebulaBasedRichTextWidget) {
                this.richtextWidget = (MDENebulaBasedRichTextWidget)widget;
            }
        } else if (this.richtextWidget.getParent() != parent) {
            this.richtextWidget.setParent(parent);
        }
        return this.richtextWidget;
    }

    public void removeWidget(Composite parent) {
        if (!this.invisibleShell.isDisposed() && !this.richtextWidget.isEditorDisposed() && this.richtextWidget.getParent() == parent) {
            this.richtextWidget.setParent((Composite)this.invisibleShell);
        }
    }

    public MDERichTextWidget addWidget(Composite parent) {
        return this.getRichtextWidget(parent);
    }

    public boolean isOnWidget(Composite parent) {
        return !this.richtextWidget.isEditorDisposed() && this.richtextWidget.getParent() == parent;
    }

    public boolean isRichTextEnabled() {
        String property = System.getProperty("disable.nebula.richtext");
        if (property != null) {
            return Boolean.valueOf(property) == false;
        }
        return true;
    }
}

