/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.sections;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.progress.UIJob;
import org.polarsys.capella.core.data.capellacore.CapellaElement;
import org.polarsys.capella.core.model.handler.helpers.CapellaAdapterHelper;
import org.polarsys.capella.core.ui.properties.richtext.sections.DescriptionPropertySection;

public class CapellaDescriptionPropertySection
extends DescriptionPropertySection {
    private static Map<CapellaDescriptionPropertySection, EObject> mapDescriptionSectionToEObject = new HashMap<CapellaDescriptionPropertySection, EObject>();
    DelayedSetDescription job = new DelayedSetDescription("Load Description");

    public boolean select(Object toTest) {
        EObject eObj = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)toTest);
        return eObj instanceof CapellaElement || eObj instanceof DRepresentationDescriptor;
    }

    @Override
    public void dispose() {
        super.dispose();
        EObject element = mapDescriptionSectionToEObject.remove((Object)this);
        if (element != null && this.isDisplayedInWizard()) {
            Set<CapellaDescriptionPropertySection> availableDescriptionSections = mapDescriptionSectionToEObject.keySet();
            for (CapellaDescriptionPropertySection descriptionSection : availableDescriptionSections) {
                if (descriptionSection == null || descriptionSection.isDisplayedInWizard() || mapDescriptionSectionToEObject.get((Object)descriptionSection) != element) continue;
                descriptionSection.refresh();
                descriptionSection.aboutToBeShown();
            }
        }
    }

    @Override
    public void loadData(EObject descriptorOrCapellaElement) {
        super.loadData(descriptorOrCapellaElement);
        mapDescriptionSectionToEObject.put(this, descriptorOrCapellaElement);
        this.job.current = descriptorOrCapellaElement;
        this.job.schedule(100L);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EObject elt;
        super.setInput(part, selection);
        if (selection instanceof StructuredSelection && ((elt = CapellaAdapterHelper.resolveDescriptorOrBusinessObject((Object)((StructuredSelection)selection).getFirstElement())) instanceof CapellaElement || elt instanceof DRepresentationDescriptor)) {
            this.loadData(elt);
        }
    }

    private class DelayedSetDescription
    extends UIJob {
        EObject current;

        public DelayedSetDescription(String name) {
            super(name);
            this.current = null;
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return DelayedSetDescription.class.getSimpleName().equals(family);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            EObject element = this.current;
            if (CapellaDescriptionPropertySection.this.descriptionGroup != null) {
                if (element.eResource() != null) {
                    CapellaDescriptionPropertySection.this.descriptionGroup.loadData(element);
                }
            } else if (CapellaDescriptionPropertySection.this.descriptionFallbackGroup != null && element.eResource() != null) {
                CapellaDescriptionPropertySection.this.descriptionFallbackGroup.loadData(element);
            }
            return Status.OK_STATUS;
        }
    }
}

