/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.ui.properties.richtext.sections;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.ISection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;
import org.polarsys.capella.core.ui.properties.fields.AbstractSemanticField;
import org.polarsys.capella.core.ui.properties.richtext.RichtextManager;
import org.polarsys.capella.core.ui.properties.richtext.fields.CapellaElementDescriptionGroup;
import org.polarsys.capella.core.ui.properties.richtext.fields.FallbackDescriptionGroup;
import org.polarsys.capella.core.ui.properties.sections.AbstractSection;
import org.polarsys.kitalpha.richtext.common.util.MDERichTextHelper;

public abstract class DescriptionPropertySection
extends AbstractSection {
    protected CapellaElementDescriptionGroup descriptionGroup;
    protected FallbackDescriptionGroup descriptionFallbackGroup;

    public void createContents(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createContents(parent, aTabbedPropertySheetPage);
        this.createDescriptionWidget(this.getWidgetFactory(), parent);
    }

    protected int getColumnCount() {
        return 1;
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }

    protected void createDescriptionWidget(TabbedPropertySheetWidgetFactory widgetFactory, Composite parent) {
        if (RichtextManager.getInstance().isRichTextEnabled()) {
            this.descriptionGroup = new CapellaElementDescriptionGroup(parent, widgetFactory, (ISection)this);
        } else {
            this.descriptionFallbackGroup = new FallbackDescriptionGroup(parent, "", widgetFactory, true);
            this.descriptionFallbackGroup.setDisplayedInWizard(this.isDisplayedInWizard());
        }
    }

    public void dispose() {
        super.dispose();
        if (this.descriptionGroup != null) {
            this.descriptionGroup.dispose();
            this.descriptionGroup = null;
        }
    }

    protected EObject adaptElement(EObject object) {
        if (object instanceof DRepresentationDescriptor) {
            return object;
        }
        return super.adaptElement(object);
    }

    protected void handleParentBackground(Color color, Composite parent) {
    }

    public void aboutToBeHidden() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeHidden();
        }
        super.aboutToBeHidden();
    }

    public void aboutToBeShown() {
        if (this.descriptionGroup != null) {
            this.descriptionGroup.aboutToBeShown();
        }
        super.aboutToBeShown();
    }

    public void setEnabled(boolean enabled) {
        if (!enabled && this.descriptionGroup != null) {
            this.descriptionGroup.setEnabled(enabled);
        }
    }

    protected void setInitialEnabledState(boolean enabled) {
        if (this.descriptionGroup != null) {
            if (enabled) {
                this.descriptionGroup.setEnabled(false);
                this.descriptionGroup.setEnabled(true);
            } else {
                this.descriptionGroup.setEnabled(enabled);
            }
        }
    }

    public List<AbstractSemanticField> getSemanticFields() {
        if (this.descriptionFallbackGroup != null) {
            return Collections.singletonList(this.descriptionFallbackGroup);
        }
        return Collections.emptyList();
    }

    public void refresh() {
        if (this.shouldRefresh()) {
            super.refresh();
        }
    }

    public boolean shouldRefresh() {
        return this.descriptionGroup == null || this.descriptionGroup.shouldRefresh();
    }

    public void performFinish() {
        this.descriptionGroup.save();
    }

    public void loadData(EObject object) {
        super.loadData(object);
        this.descriptionGroup.setBaseHrefPath(MDERichTextHelper.getProjectPath((EObject)object));
    }
}

