/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.capella.core.libraries.ui.move;

import com.google.common.collect.Lists;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.SequencedCollection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.ImageURIRegistry;
import org.eclipse.emf.common.ui.dialogs.DiagnosticDialog;
import org.eclipse.emf.common.ui.viewer.ColumnViewerInformationControlToolTipSupport;
import org.eclipse.emf.common.ui.viewer.IStyledLabelDecorator;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.ui.EMFEditUIPlugin;
import org.eclipse.emf.edit.ui.dnd.ViewerDragAdapter;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.DecoratingColumLabelProvider;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionListener;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.commands.ICommandImageService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.polarsys.capella.common.flexibility.wizards.ui.FlexibilityColors;
import org.polarsys.capella.common.helpers.EcoreUtil2;
import org.polarsys.capella.common.libraries.IModel;
import org.polarsys.capella.common.libraries.manager.LibraryManager;
import org.polarsys.capella.common.libraries.manager.LibraryManagerExt;
import org.polarsys.capella.common.tools.report.util.LogExt;
import org.polarsys.capella.common.tools.report.util.ReportManagerDefaultComponents;
import org.polarsys.capella.common.ui.toolkit.ToolkitPlugin;
import org.polarsys.capella.core.data.capellamodeller.Project;
import org.polarsys.capella.core.data.core.validation.constraint.ReferentialConstraintsResourceSetListener;
import org.polarsys.capella.core.libraries.model.ICapellaModel;
import org.polarsys.capella.core.libraries.ui.Activator;
import org.polarsys.capella.core.libraries.ui.move.CollectionTreeFilter;
import org.polarsys.capella.core.libraries.ui.move.Messages;
import org.polarsys.capella.core.model.helpers.move.CapellaMoveHelper;
import org.polarsys.capella.core.model.helpers.move.MoveHelper;
import org.polarsys.capella.core.model.helpers.move.Stage;
import org.polarsys.capella.core.model.helpers.move.StageListener;
import org.polarsys.capella.core.platform.sirius.ui.navigator.actions.LocateInCapellaExplorerAction;
import org.polarsys.capella.core.platform.sirius.ui.navigator.drop.ExplorerDropAdapterAssistant;

public class MoveStagingView
extends ViewPart
implements ISelectionProvider,
ITabbedPropertySheetPageContributor,
SessionListener {
    public static final String STAGEVIEWER_CONTEXT_MENU = "org.polarsys.capella.core.libraries.ui.moveview.stageViewer";
    public static final String DESTINATIONVIEWER_CONTEXT_MENU = "org.polarsys.capella.core.libraries.ui.moveview.destinationViewer";
    public static final String VIEW_ID = "org.polarsys.capella.core.libraries.ui.moveview";
    TreeViewer stageViewer;
    TreeViewer destinationViewer;
    ColumnViewerInformationControlToolTipSupport tooltipSupport;
    FormToolkit toolkit;
    private final AdapterFactory adapterFactory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
    private final AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this.adapterFactory);
    Stage stage;
    StageListener listener;
    Form form;
    Section stageSection;
    Section destinationSection;
    IAction executeAction;
    IAction addRequiredAction;
    IAction addAllRequiredAction;
    IAction unstageAction;
    IAction stageExpandAllAction;
    IAction stageCollapseAllAction;
    IAction nextEleementAction;
    IAction previousElementAction;
    IAction clearParentAction;
    IAction destExpandAllAction;
    IAction destCollapseAllAction;
    Session session;

    public Stage getStage() {
        return this.stage;
    }

    public void init(Collection<EObject> dropped) {
        if (this.stage == null) {
            this.stage = new Stage(EcoreUtil2.getEditingDomain(dropped));
            this.listener = new StageListener(){

                public void stageChanged(Stage s) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MoveStagingView.this.handleStageChanged(s));
                }

                public void elementsAdded(Collection<EObject> elements) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MoveStagingView.this.handleStageElementsAdded(elements));
                }

                public void parentChanged(EObject staged, EObject oldParent, EObject newParent) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MoveStagingView.this.handleStageParentChanged(staged, oldParent, newParent));
                }

                public void elementsRemoved(Collection<? extends EObject> elements) {
                    PlatformUI.getWorkbench().getDisplay().asyncExec(() -> MoveStagingView.this.handleStageElementsRemoved(elements));
                }
            };
            this.stage.addStageListener(this.listener);
            this.stageViewer.setInput((Object)this.stage.getEditingDomain().getResourceSet());
            this.stageViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(true));
            this.stageViewer.setFilters(new ViewerFilter[]{new CollectionTreeFilter(this.stage.getElements(), false)});
            this.tooltipSupport = new ColumnViewerInformationControlToolTipSupport((ColumnViewer)this.stageViewer, (LocationListener)new DiagnosticDecorator.EditingDomainLocationListener(this.stage.getEditingDomain(), (StructuredViewer)this.stageViewer){

                protected void setSelection(Object object) {
                    MyLocateInCapellaExplorerAction action = new MyLocateInCapellaExplorerAction();
                    action.selectElementInCapellaExplorer((ISelection)new StructuredSelection(object));
                }
            });
            this.destinationViewer.setInput((Object)this.stage.getEditingDomain().getResourceSet());
            this.stageExpandAllAction.setEnabled(true);
            this.stageCollapseAllAction.setEnabled(true);
            this.destExpandAllAction.setEnabled(true);
            this.destCollapseAllAction.setEnabled(true);
            this.previousElementAction.setEnabled(true);
            this.nextEleementAction.setEnabled(true);
            this.initSessionListener(this.stage.getEditingDomain());
            this.stage.addAll(dropped);
        }
    }

    public void createPartControl(Composite parent) {
        this.toolkit = new FormToolkit(parent.getDisplay());
        this.form = this.toolkit.createForm(parent);
        GridLayout layout = new GridLayout(2, true);
        this.form.getBody().setLayout((Layout)layout);
        this.stageSection = this.toolkit.createSection(this.form.getBody(), 448);
        this.stageSection.setText(Messages.MoveStagingView_stageSectionTitle);
        this.stageSection.setDescription(Messages.MoveStagingView_stageSectionDescription);
        GridData gd = new GridData(4, 4, true, true);
        this.stageSection.setLayoutData((Object)gd);
        Composite stageSectionClient = this.toolkit.createComposite((Composite)this.stageSection);
        stageSectionClient.setLayout((Layout)new GridLayout(2, false));
        this.stageSection.setClient((Control)stageSectionClient);
        this.createStageViewer(stageSectionClient);
        this.destinationSection = this.toolkit.createSection(this.form.getBody(), 448);
        this.destinationSection.setText(Messages.MoveStagingView_destinationSectionTitle);
        this.destinationSection.setDescription(Messages.MoveStagingView_destinationSectionDescription);
        gd = new GridData(4, 4, true, true);
        this.destinationSection.setLayoutData((Object)gd);
        Composite destinationSectionClient = this.toolkit.createComposite((Composite)this.destinationSection);
        destinationSectionClient.setLayout((Layout)new GridLayout(2, false));
        this.destinationSection.setClient((Control)destinationSectionClient);
        this.createDestinationViewer(destinationSectionClient);
        this.getViewSite().setSelectionProvider((ISelectionProvider)this);
        this.initTreePacker();
        this.initSelectionSynchronizer();
        this.initToolbar();
    }

    private void initToolbar() {
        ImageDescriptor descriptor = DebugPluginImages.getImageRegistry().getDescriptor("IMG_ACT_RUN");
        this.executeAction = new Action("", descriptor){

            public void run() {
                AtomicBoolean forcedMove = new AtomicBoolean();
                AtomicReference referenceErrors = new AtomicReference();
                MoveStagingView.this.destinationViewer.getTree().setRedraw(false);
                ReferentialConstraintsResourceSetListener validateListener = new ReferentialConstraintsResourceSetListener(status -> {
                    referenceErrors.set(status);
                    MyDiagnosticDialog dialog = new MyDiagnosticDialog(MoveStagingView.this.getViewSite().getShell(), status);
                    if (dialog.open() == 1) {
                        throw new RollbackException((IStatus)new Status(8, "org.polarsys.capella.core.libraries.ui", Messages.MoveStagingView_CancelStatusMessage));
                    }
                    forcedMove.set(true);
                });
                TransactionalEditingDomain domain = (TransactionalEditingDomain)MoveStagingView.this.stage.getEditingDomain();
                domain.addResourceSetListener((ResourceSetListener)validateListener);
                Diagnostic result = null;
                try {
                    result = MoveStagingView.this.stage.executeWithDiagnostics();
                    MoveStagingView.this.report(result);
                    if (result.getSeverity() == 0) {
                        boolean resetView = false;
                        Diagnostic referenceErrorDiagnostic = (Diagnostic)referenceErrors.get();
                        if (referenceErrorDiagnostic != null) {
                            MoveStagingView.this.report(referenceErrorDiagnostic);
                            String userDecision = null;
                            if (forcedMove.get()) {
                                userDecision = Messages.MoveStagingView_forced_move_message;
                                resetView = true;
                            } else {
                                userDecision = Messages.MoveStagingView_CancelStatusMessage;
                            }
                            MoveStagingView.this.report((Diagnostic)new BasicDiagnostic(Stage.SOURCE, 0, userDecision, new Object[0]));
                        } else {
                            resetView = true;
                        }
                        if (resetView) {
                            MoveStagingView.this.reset();
                        }
                    } else {
                        DiagnosticDialog.open((Shell)MoveStagingView.this.getViewSite().getShell(), (String)Messages.MoveStagingView_fail_dialog_title, (String)Messages.MoveStagingView_fail_dialog_message, (Diagnostic)result);
                    }
                }
                finally {
                    domain.removeResourceSetListener((ResourceSetListener)validateListener);
                    MoveStagingView.this.destinationViewer.getTree().setRedraw(true);
                }
            }
        };
        this.executeAction.setEnabled(false);
        this.getViewSite().getActionBars().getToolBarManager().add(this.executeAction);
    }

    private void report(Diagnostic d) {
        Priority prio = LogExt.convertSeverityToPriority((Diagnostic)d);
        if (d.getChildren().isEmpty()) {
            ReportManagerDefaultComponents.getReportManagerForModel().log(prio, (Object)d);
        } else {
            for (Diagnostic child : d.getChildren()) {
                this.report(child);
            }
        }
    }

    private void initSelectionSynchronizer() {
        ISelectionChangedListener listener = new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeViewer target = null;
                if (((TreeViewer)event.getSelectionProvider()).getTree().isFocusControl()) {
                    target = event.getSelectionProvider() == MoveStagingView.this.stageViewer ? MoveStagingView.this.destinationViewer : MoveStagingView.this.stageViewer;
                    if (((IStructuredSelection)event.getSelection()).size() == 1) {
                        Object elem = ((IStructuredSelection)event.getSelection()).getFirstElement();
                        if (MoveStagingView.this.stage.getElements().contains(elem)) {
                            target.setSelection(event.getSelection());
                            target.reveal(elem);
                        }
                    }
                }
            }
        };
        this.stageViewer.addSelectionChangedListener(listener);
        this.destinationViewer.addSelectionChangedListener(listener);
    }

    private void initTreePacker() {
        TreeListener packer = new TreeListener(){

            private void pack(final TreeEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!e.widget.isDisposed()) {
                            ((Tree)e.widget).getColumn(0).pack();
                        }
                    }
                });
            }

            public void treeExpanded(TreeEvent e) {
                this.pack(e);
            }

            public void treeCollapsed(TreeEvent e) {
                this.pack(e);
            }
        };
        this.stageViewer.getTree().addTreeListener(packer);
        this.destinationViewer.getTree().addTreeListener(packer);
    }

    private void createStageViewer(Composite stageSectionClient) {
        this.stageViewer = new TreeViewer(this.toolkit.createTree(stageSectionClient, 2050));
        GridData gd = new GridData(4, 4, true, true);
        this.stageViewer.getTree().setLayoutData((Object)gd);
        TreeColumn column = new TreeColumn(this.stageViewer.getTree(), 16384);
        column.setWidth(200);
        this.stageViewer.setAutoExpandLevel(3);
        this.stageViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory){

            public Object[] getElements(Object object) {
                LinkedHashSet<EObject> elems = new LinkedHashSet<EObject>();
                for (EObject e : MoveStagingView.this.stage.getElements()) {
                    elems.add(EcoreUtil.getRootContainer((EObject)e));
                }
                return elems.toArray();
            }

            public Object getParent(Object object) {
                return ((EObject)object).eContainer();
            }
        });
        this.stageViewer.addDropSupport(2, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.stageViewer){

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                ISelection sel = LocalSelectionTransfer.getTransfer().getSelection();
                if (sel instanceof IStructuredSelection) {
                    ArrayList<EObject> eObjects = new ArrayList<EObject>();
                    for (Object next : (IStructuredSelection)sel) {
                        if (next instanceof EObject) {
                            eObjects.add((EObject)next);
                            continue;
                        }
                        return false;
                    }
                    TransactionalEditingDomain editingDomain = EcoreUtil2.getEditingDomain(eObjects);
                    if (editingDomain == null) {
                        return false;
                    }
                    if (MoveStagingView.this.stage == null || MoveStagingView.this.stage.getEditingDomain() == editingDomain && Collections.disjoint(MoveStagingView.this.stage.getElements(), eObjects)) {
                        return true;
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                List dropped = ((IStructuredSelection)data).toList();
                if (MoveStagingView.this.stage == null) {
                    MoveStagingView.this.init(dropped);
                } else {
                    MoveStagingView.this.stage.addAll((Collection)dropped);
                }
                return true;
            }
        });
        this.stageViewer.addDragSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ViewerDragAdapter((Viewer)this.stageViewer){

            public void dragStart(DragSourceEvent event) {
                if (MoveStagingView.this.stage.getElements().containsAll(MoveStagingView.this.stageViewer.getStructuredSelection().toList())) {
                    super.dragStart(event);
                } else {
                    event.doit = false;
                }
            }

            public void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                MoveStagingView.this.stageViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                MoveStagingView.this.stageViewer.refresh();
            }
        });
        ToolBarManager stageViewerToolBarManager = new ToolBarManager(0x800200);
        ToolBar stageViewerToolbar = stageViewerToolBarManager.createControl(stageSectionClient);
        gd = new GridData(0x1000000, 128, false, false);
        stageViewerToolbar.setLayoutData((Object)gd);
        this.unstageAction = new UnstageAction();
        this.addRequiredAction = new AddRequiredAction();
        this.addAllRequiredAction = new AddAllRequiredAction();
        this.stageExpandAllAction = new ExpandAllAction(this.stageViewer);
        this.stageExpandAllAction.setEnabled(false);
        this.stageCollapseAllAction = new CollapseAllAction(this.stageViewer);
        this.stageCollapseAllAction.setEnabled(false);
        this.previousElementAction = new PreviousElementAction(this.stageViewer);
        this.previousElementAction.setEnabled(false);
        this.nextEleementAction = new NextElementAction(this.stageViewer);
        this.nextEleementAction.setEnabled(false);
        this.stageViewer.addSelectionChangedListener((ISelectionChangedListener)this.addRequiredAction);
        this.stageViewer.addSelectionChangedListener((ISelectionChangedListener)this.unstageAction);
        this.stageViewer.addSelectionChangedListener((ISelectionChangedListener)this.addAllRequiredAction);
        stageViewerToolBarManager.add(this.stageExpandAllAction);
        stageViewerToolBarManager.add(this.stageCollapseAllAction);
        stageViewerToolBarManager.add(this.previousElementAction);
        stageViewerToolBarManager.add(this.nextEleementAction);
        stageViewerToolBarManager.add(this.unstageAction);
        stageViewerToolBarManager.add(this.addRequiredAction);
        stageViewerToolBarManager.add(this.addAllRequiredAction);
        this.stageViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        stageViewerToolBarManager.update(true);
        MenuManager stageContextMenu = new MenuManager();
        stageContextMenu.setRemoveAllWhenShown(true);
        stageContextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (MoveStagingView.this.unstageAction.isEnabled()) {
                    manager.add(MoveStagingView.this.unstageAction);
                }
                if (MoveStagingView.this.addRequiredAction.isEnabled()) {
                    manager.add(MoveStagingView.this.addRequiredAction);
                }
                if (MoveStagingView.this.addAllRequiredAction.isEnabled()) {
                    manager.add(MoveStagingView.this.addAllRequiredAction);
                }
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        this.stageViewer.getControl().setMenu(stageContextMenu.createContextMenu(this.stageViewer.getControl()));
        this.getViewSite().registerContextMenu(STAGEVIEWER_CONTEXT_MENU, stageContextMenu, (ISelectionProvider)this.stageViewer);
    }

    private void initSessionListener(EditingDomain editingDomain) {
        for (Session session : SessionManager.INSTANCE.getSessions()) {
            if (session.getTransactionalEditingDomain() != this.stage.getEditingDomain()) continue;
            this.session = session;
            session.addListener((SessionListener)this);
        }
    }

    private CellLabelProvider createLabelProvider(boolean showErrorCount) {
        return new DelegatingStyledCellLabelProvider((DelegatingStyledCellLabelProvider.IStyledLabelProvider)new DecoratingColumLabelProvider.StyledLabelProvider((ILabelProvider)this.labelProvider, (ILabelDecorator)new StageLabelDecorator(showErrorCount)));
    }

    private void createDestinationViewer(Composite destinationSectionClient) {
        this.destinationViewer = new TreeViewer(this.toolkit.createTree(destinationSectionClient, 2050));
        TreeColumn column2 = new TreeColumn(this.destinationViewer.getTree(), 16384);
        column2.setWidth(200);
        GridData gd = new GridData(4, 4, true, true);
        this.destinationViewer.getControl().setLayoutData((Object)gd);
        this.destinationViewer.setAutoExpandLevel(3);
        this.destinationViewer.setLabelProvider((IBaseLabelProvider)this.createLabelProvider(false));
        this.destinationViewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider(this.adapterFactory){

            public Object[] getElements(Object object) {
                ArrayList<Project> result = new ArrayList<Project>();
                TransactionalEditingDomain domain = TransactionUtil.getEditingDomain((Object)object);
                IModel model = LibraryManager.INSTANCE.getModel(domain);
                for (IModel lib : LibraryManagerExt.getAllReferences((IModel)model)) {
                    if (!(lib instanceof ICapellaModel)) continue;
                    result.add(((ICapellaModel)lib).getProject(domain));
                }
                return result.toArray();
            }

            public boolean hasChildren(Object object) {
                for (Object o : MoveStagingView.this.stage.getElements()) {
                    if (MoveStagingView.this.stage.getNewParent((EObject)o) != object) continue;
                    return true;
                }
                return super.hasChildren(object);
            }

            public Object[] getChildren(Object element) {
                ArrayList<EObject> newChildren = null;
                for (EObject e : MoveStagingView.this.stage.getElements()) {
                    if (element != MoveStagingView.this.stage.getNewParent(e)) continue;
                    if (newChildren == null) {
                        newChildren = new ArrayList<EObject>();
                    }
                    newChildren.add(e);
                }
                ArrayList result = Lists.newArrayList((Object[])super.getChildren(element));
                if (newChildren != null) {
                    Iterator it = result.iterator();
                    while (it.hasNext()) {
                        Object next = it.next();
                        if (!newChildren.contains(next)) continue;
                        it.remove();
                    }
                    result.addAll(newChildren);
                }
                return result.toArray();
            }
        });
        this.destinationViewer.addDropSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DropTargetListener)new ViewerDropAdapter((Viewer)this.destinationViewer){
            final ExplorerDropAdapterAssistant a;
            {
                this.a = new ExplorerDropAdapterAssistant((MoveHelper)new CapellaMoveHelper());
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                ISelection sel;
                IWorkbenchPart active;
                if (LocalSelectionTransfer.getTransfer().isSupportedType(transferType) && (active = MoveStagingView.this.getSite().getPage().getActivePart()) == MoveStagingView.this && (sel = LocalSelectionTransfer.getTransfer().getSelection()) instanceof IStructuredSelection) {
                    List selected = ((IStructuredSelection)sel).toList();
                    if (MoveStagingView.this.stage != null && MoveStagingView.this.stage.getElements().containsAll(selected)) {
                        return this.a.validateDrop(target, operation, transferType).isOK();
                    }
                }
                return false;
            }

            public boolean performDrop(Object data) {
                List staged = ((IStructuredSelection)data).toList();
                for (EObject e : staged) {
                    MoveStagingView.this.stage.setParent(e, (EObject)this.getCurrentTarget());
                }
                return true;
            }
        });
        this.destinationViewer.addDragSupport(0, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new ViewerDragAdapter((Viewer)this.destinationViewer){

            public void dragStart(DragSourceEvent event) {
                if (!MoveStagingView.this.stage.getElements().containsAll(((IStructuredSelection)this.viewer.getSelection()).toList())) {
                    event.doit = false;
                }
                super.dragStart(event);
            }
        });
        ToolBarManager destinationViewerToolBarManager = new ToolBarManager(0x800200);
        ToolBar destinationViewerToolbar = destinationViewerToolBarManager.createControl(destinationSectionClient);
        gd = new GridData(0x1000000, 128, false, false);
        destinationViewerToolbar.setLayoutData((Object)gd);
        this.clearParentAction = new ClearParentAction();
        this.destinationViewer.addSelectionChangedListener((ISelectionChangedListener)this.clearParentAction);
        this.destExpandAllAction = new ExpandAllAction(this.destinationViewer);
        this.destExpandAllAction.setEnabled(false);
        this.destCollapseAllAction = new CollapseAllAction(this.destinationViewer);
        this.destCollapseAllAction.setEnabled(false);
        destinationViewerToolBarManager.add(this.destExpandAllAction);
        destinationViewerToolBarManager.add(this.destCollapseAllAction);
        destinationViewerToolBarManager.add(this.clearParentAction);
        destinationViewerToolBarManager.update(true);
        final MenuManager destinationContextMenu = new MenuManager();
        destinationContextMenu.setRemoveAllWhenShown(true);
        destinationContextMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                if (MoveStagingView.this.clearParentAction.isEnabled()) {
                    manager.add(MoveStagingView.this.clearParentAction);
                }
                destinationContextMenu.add((IContributionItem)new Separator("additions"));
            }
        });
        this.destinationViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.destinationViewer.getControl().setMenu(destinationContextMenu.createContextMenu(this.destinationViewer.getControl()));
        this.getViewSite().registerContextMenu(DESTINATIONVIEWER_CONTEXT_MENU, destinationContextMenu, (ISelectionProvider)this.destinationViewer);
    }

    public void setFocus() {
        this.stageViewer.getControl().setFocus();
    }

    private void handleStageChanged(Stage s) {
        this.stageViewer.refresh(true);
        this.destinationViewer.refresh(true);
        this.stageViewer.getTree().getColumn(0).pack();
        this.updateActions();
    }

    private void handleStageElementsAdded(Collection<EObject> elements) {
        this.handleStageChanged(this.stage);
        for (EObject e : elements) {
            this.stageViewer.reveal((Object)e);
        }
        TreeIterator it = EcoreUtil.getAllContents(elements);
        while (it.hasNext()) {
            EObject next = (EObject)it.next();
            if (!this.stage.hasBackreferences(next)) continue;
            this.stageViewer.reveal((Object)next);
        }
        this.stageViewer.getTree().getColumn(0).pack();
    }

    private void handleStageParentChanged(EObject staged, EObject oldParent, EObject newParent) {
        if (oldParent != null) {
            this.destinationViewer.refresh((Object)oldParent, true);
        }
        this.destinationViewer.refresh((Object)newParent, true);
        if (newParent != null) {
            this.destinationViewer.setExpandedState((Object)newParent, true);
        } else {
            this.stageViewer.update((Object)staged, null);
        }
        this.destinationViewer.getTree().getColumn(0).pack();
        this.updateActions();
    }

    private void handleStageElementsRemoved(Collection<? extends EObject> elements) {
        if (this.stage.getElements().isEmpty()) {
            this.reset();
        } else {
            this.stageViewer.refresh(true);
            this.destinationViewer.refresh(true);
            this.stageViewer.getTree().getColumn(0).pack();
            this.destinationViewer.getTree().getColumn(0).pack();
            this.updateActions();
        }
    }

    private void updateActions() {
        this.executeAction.setEnabled(this.stage != null && this.stage.canExecute());
        ((BaseSelectionListenerAction)this.unstageAction).selectionChanged((IStructuredSelection)this.stageViewer.getStructuredSelection());
        ((BaseSelectionListenerAction)this.addRequiredAction).selectionChanged((IStructuredSelection)this.stageViewer.getStructuredSelection());
        ((BaseSelectionListenerAction)this.addAllRequiredAction).selectionChanged((IStructuredSelection)this.stageViewer.getStructuredSelection());
        ((BaseSelectionListenerAction)this.clearParentAction).selectionChanged((IStructuredSelection)this.destinationViewer.getStructuredSelection());
    }

    public void reset() {
        this.stageViewer.setInput(null);
        this.destinationViewer.setInput(null);
        if (this.stage != null) {
            if (this.listener != null) {
                this.stage.removeStageListener(this.listener);
            }
            this.stage.dispose();
            this.stage = null;
        }
        this.stageExpandAllAction.setEnabled(false);
        this.stageCollapseAllAction.setEnabled(false);
        this.destExpandAllAction.setEnabled(false);
        this.destCollapseAllAction.setEnabled(false);
        this.nextEleementAction.setEnabled(false);
        this.previousElementAction.setEnabled(false);
        if (this.session != null) {
            this.session.removeListener((SessionListener)this);
            this.session = null;
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.stageViewer.addSelectionChangedListener(listener);
        this.destinationViewer.addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.stageViewer.getControl().isFocusControl() ? this.stageViewer.getSelection() : this.destinationViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.stageViewer.removeSelectionChangedListener(listener);
        this.destinationViewer.removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.stageViewer.setSelection(selection);
    }

    public String getContributorId() {
        return "org.polarsys.capella.core.data.capellamodeller.properties";
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IPropertySheetPage.class) {
            return new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return super.getAdapter(adapter);
    }

    public void dispose() {
        this.labelProvider.dispose();
        if (this.toolkit != null) {
            this.toolkit.dispose();
        }
        if (this.stage != null) {
            this.stage.dispose();
        }
        if (this.tooltipSupport != null) {
            this.tooltipSupport.dispose();
        }
        if (this.session != null) {
            this.session.removeListener((SessionListener)this);
        }
    }

    public void notify(int changeKind) {
        if (changeKind == 8) {
            this.reset();
        }
    }

    private abstract class AbstractAddRequiredAction
    extends BaseSelectionListenerAction {
        protected AbstractAddRequiredAction(String text) {
            super(text);
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            boolean enabled = false;
            for (EObject next : selection) {
                if (MoveStagingView.this.stage == null || MoveStagingView.this.stage.getBackreferences(next).size() <= 0) continue;
                enabled = true;
                break;
            }
            return enabled;
        }
    }

    private class AbstractDeleteAction
    extends BaseSelectionListenerAction {
        @Deprecated
        private static final String DELETE_IMAGE = "org.polarsys.capella.common.re.subcommands.delete";

        protected AbstractDeleteAction(String text) {
            super(text);
            ICommandImageService service = (ICommandImageService)MoveStagingView.this.getViewSite().getService(ICommandImageService.class);
            this.setImageDescriptor(service.getImageDescriptor(DELETE_IMAGE));
        }

        protected boolean updateSelection(IStructuredSelection selection) {
            return MoveStagingView.this.stage != null && !selection.isEmpty();
        }
    }

    private class AddAllRequiredAction
    extends AbstractAddRequiredAction {
        protected AddAllRequiredAction() {
            super(Messages.MoveStagingView_addAllRequiredElementsLabel);
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("full/etool16/add_alldependencies.gif"));
            this.setToolTipText(Messages.MoveStagingView_addAllRequiredElementsLabel);
        }

        public void run() {
            SequencedCollection input = this.getStructuredSelection().toList();
            while (!input.isEmpty()) {
                LinkedHashSet backrefs = new LinkedHashSet();
                for (EObject e : input) {
                    backrefs.addAll(MoveStagingView.this.stage.getBackreferences(e).values());
                }
                MoveStagingView.this.stage.addAll(backrefs);
                input = backrefs;
            }
        }
    }

    private class AddRequiredAction
    extends AbstractAddRequiredAction {
        private AddRequiredAction() {
            super(Messages.MoveStagingView_addRequiredElementsLabel);
            this.setImageDescriptor(Activator.getDefault().getImageDescriptor("full/etool16/add_dependencies.gif"));
            this.setToolTipText(Messages.MoveStagingView_addRequiredElementsLabel);
        }

        public void run() {
            LinkedHashSet toAdd = new LinkedHashSet();
            for (EObject next : this.getStructuredSelection()) {
                toAdd.addAll(MoveStagingView.this.stage.getBackreferences(next).values());
            }
            MoveStagingView.this.stage.addAll(toAdd);
        }
    }

    private final class ClearParentAction
    extends AbstractDeleteAction {
        private ClearParentAction() {
            super(Messages.MoveStagingView_clearParentLabel);
            this.setToolTipText(Messages.MoveStagingView_clearParentLabel);
        }

        public void run() {
            List emfObjects = MoveStagingView.this.destinationViewer.getStructuredSelection().toList();
            for (EObject e : MoveStagingView.this.stage.getElements()) {
                if (!EcoreUtil.isAncestor((Collection)emfObjects, (EObject)MoveStagingView.this.stage.getNewParent(e))) continue;
                MoveStagingView.this.stage.setParent(e, null);
            }
        }
    }

    private class CollapseAllAction
    extends TreeViewerAction {
        public CollapseAllAction(TreeViewer viewer) {
            super(viewer);
            this.setText(Messages.MoveStagingView_collapseAllAction_text);
            this.setToolTipText(Messages.MoveStagingView_collapseAllAction_tooltip);
            this.setImageDescriptor(((ICommandImageService)MoveStagingView.this.getViewSite().getService(ICommandImageService.class)).getImageDescriptor("org.eclipse.ui.navigate.collapseAll"));
        }

        public void run() {
            try {
                this.getViewer().getControl().setRedraw(false);
                this.getViewer().collapseAll();
                this.getViewer().getTree().getColumn(0).pack();
            }
            finally {
                this.getViewer().getControl().setRedraw(true);
            }
        }
    }

    private class ExpandAllAction
    extends TreeViewerAction {
        public ExpandAllAction(TreeViewer viewer) {
            super(viewer);
            this.setText(Messages.MoveStagingView_expandAllAction_text);
            this.setToolTipText(Messages.MoveStagingView_expandAllAction_tooltip);
            this.setImageDescriptor(((ICommandImageService)MoveStagingView.this.getViewSite().getService(ICommandImageService.class)).getImageDescriptor("org.eclipse.ui.navigate.expandAll"));
        }

        public void run() {
            try {
                this.getViewer().getControl().setRedraw(false);
                this.getViewer().expandAll();
                this.getViewer().getTree().getColumn(0).pack();
            }
            finally {
                this.getViewer().getControl().setRedraw(true);
            }
        }
    }

    private static class MyDiagnosticDialog
    extends DiagnosticDialog {
        public MyDiagnosticDialog(Shell parent, Diagnostic diagnostic) {
            super(parent, Messages.ValidateExecuteListener_dialogTitle, Messages.ValidateExecuteListener_dialogMessage, diagnostic, 6);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createDetailsButton(parent);
            this.createButton(parent, 0, Messages.ValidateExecuteListener_dialogProceedButton, false);
            this.createButton(parent, 1, Messages.ValidateExecuteListener_dialogCancelButton, true);
        }
    }

    private static class MyLocateInCapellaExplorerAction
    extends LocateInCapellaExplorerAction {
        private MyLocateInCapellaExplorerAction() {
        }

        public void selectElementInCapellaExplorer(ISelection selection) {
            IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            try {
                window.getActivePage().showView("capella.project.explorer", null, 1);
            }
            catch (PartInitException e) {
                Activator.getDefault().getLog().log((IStatus)new Status(4, "org.polarsys.capella.core.libraries.ui", e.getLocalizedMessage(), (Throwable)e));
            }
            super.selectElementInCapellaExplorer(selection);
        }
    }

    private class NavigateStageAction
    extends TreeViewerAction {
        final boolean forward;

        NavigateStageAction(TreeViewer viewer, boolean forward) {
            super(viewer);
            this.forward = forward;
        }

        /*
         * Unable to fully structure code
         */
        public void runWithEvent(Event event) {
            matcher = (event.stateMask & 262144) == 262144 ? (Predicate<EObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, ctrlMatcher(org.eclipse.emf.ecore.EObject ), (Lorg/eclipse/emf/ecore/EObject;)Z)((NavigateStageAction)this) : (Predicate<EObject>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, defaultMatcher(org.eclipse.emf.ecore.EObject ), (Lorg/eclipse/emf/ecore/EObject;)Z)((NavigateStageAction)this);
            cp = (ITreeContentProvider)this.getViewer().getContentProvider();
            selection = (EObject)((IStructuredSelection)this.getViewer().getSelection()).getFirstElement();
            if (selection == null) {
                roots = cp.getElements(this.getViewer().getInput());
                if (this.forward) {
                    selection = (EObject)roots[0];
                } else {
                    selection = (EObject)roots[roots.length - 1];
                    while (cp.hasChildren((Object)selection)) {
                        children = cp.getChildren((Object)selection);
                        selection = (EObject)children[children.length - 1];
                    }
                }
            }
            currentElement = matcher.test(root = selection) != false ? root : null;
            nextElement = null;
            while (nextElement == null && root != null) {
                block10: {
                    if (this.forward) {
                        nextElement = this.searchDown(root, currentElement, matcher);
                    } else if (root != selection) {
                        nextElement = this.searchUp(root, matcher);
                    }
                    if (nextElement != null) continue;
                    v0 = nextSubtree = this.forward != false ? this.getRightSibling(root) : this.getLeftSibling(root);
                    if (nextSubtree != null) break block10;
                    parent = root.eContainer();
                    if (parent == null || this.forward || !matcher.test(parent)) ** GOTO lbl31
                    nextElement = parent;
                    break block10;
lbl-1000:
                    // 1 sources

                    {
                        nextSubtree = this.forward != false ? this.getRightSibling(parent) : this.getLeftSibling(parent);
                        parent = parent.eContainer();
lbl31:
                        // 2 sources

                        ** while (parent != null && nextSubtree == null)
                    }
                }
                root = nextSubtree;
            }
            if (nextElement != null) {
                this.getViewer().setSelection((ISelection)new StructuredSelection(nextElement));
                this.getViewer().reveal((Object)nextElement);
            }
        }

        private EObject getRightSibling(EObject e) {
            Object[] siblings = this.getSiblings(e);
            int i = 0;
            while (i < siblings.length - 1) {
                if (siblings[i] == e) {
                    return (EObject)siblings[i + 1];
                }
                ++i;
            }
            return null;
        }

        private EObject getLeftSibling(EObject e) {
            Object[] siblings = this.getSiblings(e);
            int i = 1;
            while (i < siblings.length) {
                if (siblings[i] == e) {
                    return (EObject)siblings[i - 1];
                }
                ++i;
            }
            return null;
        }

        private Object[] getSiblings(Object e) {
            ITreeContentProvider tcp = (ITreeContentProvider)this.getViewer().getContentProvider();
            Object parent = tcp.getParent(e);
            Object[] siblings = null;
            siblings = parent == null ? tcp.getElements(this.getViewer().getInput()) : tcp.getChildren(parent);
            return siblings;
        }

        private EObject searchDown(EObject root, EObject current, Predicate<EObject> matcher) {
            ArrayDeque<EObject> toWalk = new ArrayDeque<EObject>();
            toWalk.add(root);
            while (toWalk.size() > 0) {
                EObject next = (EObject)toWalk.pop();
                if (next != current && matcher.test(next)) {
                    return next;
                }
                Object[] children = ((ITreeContentProvider)this.getViewer().getContentProvider()).getChildren((Object)next);
                int i = children.length - 1;
                while (i >= 0) {
                    toWalk.push((EObject)children[i]);
                    --i;
                }
            }
            return null;
        }

        private EObject searchUp(EObject root, Predicate<EObject> matcher) {
            EObject next;
            ArrayDeque<EObject> postOrderRL = new ArrayDeque<EObject>();
            ArrayDeque<EObject> toWalk = new ArrayDeque<EObject>();
            toWalk.push(root);
            while (!toWalk.isEmpty()) {
                next = (EObject)toWalk.pop();
                postOrderRL.push(next);
                Object[] children = ((ITreeContentProvider)this.getViewer().getContentProvider()).getChildren((Object)next);
                int i = children.length - 1;
                while (i >= 0) {
                    toWalk.push((EObject)children[i]);
                    --i;
                }
            }
            while (!postOrderRL.isEmpty()) {
                next = (EObject)postOrderRL.pop();
                if (!matcher.test(next)) continue;
                return next;
            }
            return null;
        }

        private boolean hasBackreferenceMatcher(EObject e) {
            return !MoveStagingView.this.stage.getBackreferences(e).isEmpty();
        }

        private boolean isStageElementMatcher(EObject e) {
            return MoveStagingView.this.stage.getElements().contains(e);
        }

        private boolean hasNoNewParentMatcher(EObject e) {
            return MoveStagingView.this.stage.getNewParent(e) == null;
        }

        private boolean ctrlMatcher(EObject e) {
            return this.hasBackreferenceMatcher(e) || this.isStageElementMatcher(e) && this.hasNoNewParentMatcher(e);
        }

        private boolean defaultMatcher(EObject e) {
            return this.hasBackreferenceMatcher(e) || this.isStageElementMatcher(e);
        }
    }

    private class NextElementAction
    extends NavigateStageAction {
        public NextElementAction(TreeViewer viewer) {
            super(viewer, true);
            this.setText(Messages.MoveStagingView_nextElementAction_text);
            this.setToolTipText(Messages.MoveStagingView_nextElementAction_tooltip);
            this.setImageDescriptor(ToolkitPlugin.getDefault().getImageRegistry().getDescriptor("toolitem.move_down"));
        }
    }

    private class PreviousElementAction
    extends NavigateStageAction {
        public PreviousElementAction(TreeViewer viewer) {
            super(viewer, false);
            this.setText(Messages.MoveStagingView_previousElementAction_text);
            this.setToolTipText(Messages.MoveStagingView_previousElementAction_tooltip);
            this.setImageDescriptor(ToolkitPlugin.getDefault().getImageRegistry().getDescriptor("toolitem.move_up"));
        }
    }

    class StageLabelDecorator
    extends CellLabelProvider
    implements IStyledLabelDecorator {
        private boolean showErrorCount;
        private Font boldFont;
        private StyledString.Styler boldFontStyler;
        private Font italicFont;
        private StyledString.Styler italicFontStyler;
        final StyledString.Styler errorColorStyler = StyledString.createColorRegistryStyler((String)"ERROR_COLOR", null);
        final StyledString.Styler greenColorStyler = new StyledString.Styler(){

            public void applyStyles(TextStyle textStyle) {
                textStyle.foreground = FlexibilityColors.getColorRegistry().get("greenColor");
            }
        };

        StageLabelDecorator() {
            this.showErrorCount = false;
        }

        StageLabelDecorator(boolean showErrorCount) {
            this.showErrorCount = showErrorCount;
        }

        public Image decorateImage(Image image, Object element) {
            Collection diagnostic = MoveStagingView.this.stage.getDiagnostics((EObject)element);
            for (Diagnostic diag : diagnostic) {
                if (diagnostic == null || diag.getSeverity() < 2) continue;
                return this.decorate(image, diag);
            }
            return image;
        }

        public Image decorate(Image image, Diagnostic diagnostic) {
            ArrayList<Object> images = new ArrayList<Object>(2);
            images.add(image);
            images.add(EMFEditUIPlugin.INSTANCE.getImage(diagnostic.getSeverity() == 2 ? "full/ovr16/warning_ovr.gif" : "full/ovr16/error_ovr.gif"));
            ComposedImage composedImage = new ComposedImage(images);
            return ExtendedImageRegistry.INSTANCE.getImage((Object)composedImage);
        }

        public String decorateText(String text, Object element) {
            return text;
        }

        protected void buildToolTipMessage(StringBuilder result, ILabelProvider labelProvider, Object object, Diagnostic diagnostic) {
            EObject target = (EObject)diagnostic.getData().get(1);
            EReference ref = (EReference)diagnostic.getData().get(2);
            result.append("<div>");
            String sourceText = DiagnosticDecorator.escapeContent((String)labelProvider.getText(object));
            URI sourceImage = ImageURIRegistry.INSTANCE.getImageURI(labelProvider.getImage(object));
            String targetText = DiagnosticDecorator.escapeContent((String)labelProvider.getText((Object)target));
            URI targetImage = ImageURIRegistry.INSTANCE.getImageURI(labelProvider.getImage((Object)target));
            result.append(sourceText);
            result.append(String.format(Messages.MoveStagingView_backrefTooltip, sourceImage, EcoreUtil.getURI((EObject)target), targetText, targetImage, DiagnosticDecorator.escapeContent((String)labelProvider.getText((Object)ref))));
            result.append("</div>");
        }

        public String getToolTipText(Object element) {
            Collection diags = MoveStagingView.this.stage.getDiagnostics((EObject)element);
            if (diags != null && diags.size() > 0) {
                Diagnostic d = (Diagnostic)diags.iterator().next();
                StringBuilder builder = new StringBuilder();
                this.buildToolTipMessage(builder, (ILabelProvider)MoveStagingView.this.labelProvider, element, d);
                return builder.toString();
            }
            return null;
        }

        private int countChildrenBackreferences(EObject element) {
            int result = 0;
            TreeIterator it = element.eAllContents();
            while (it.hasNext()) {
                if (MoveStagingView.this.stage.getBackreferences((EObject)it.next()).size() <= 0) continue;
                ++result;
            }
            return result;
        }

        public StyledString decorateStyledText(StyledString styledString, final Object element) {
            int backrefs;
            final StyledString.Styler fontStyler = this.getFontStyler(element);
            StyledString.Styler mainStyler = new StyledString.Styler(){

                public void applyStyles(TextStyle textStyle) {
                    StyledString.Styler colorStyler;
                    StyledString.Styler fontStyler = StageLabelDecorator.this.getFontStyler(element);
                    if (fontStyler != null) {
                        fontStyler.applyStyles(textStyle);
                    }
                    if ((colorStyler = StageLabelDecorator.this.getColorStyler(element)) != null) {
                        colorStyler.applyStyles(textStyle);
                    }
                }
            };
            styledString.setStyle(0, styledString.length(), mainStyler);
            if (this.showErrorCount && (backrefs = this.countChildrenBackreferences((EObject)element)) > 0) {
                StyledString.Styler errorCountStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        if (fontStyler != null) {
                            fontStyler.applyStyles(textStyle);
                        }
                        StageLabelDecorator.this.errorColorStyler.applyStyles(textStyle);
                    }
                };
                styledString.append(" (" + String.valueOf(backrefs) + ")", errorCountStyler);
            }
            return styledString;
        }

        private StyledString.Styler getColorStyler(Object object) {
            if (MoveStagingView.this.stage.hasBackreferences((EObject)object)) {
                return this.errorColorStyler;
            }
            if (MoveStagingView.this.stage.getNewParent((EObject)object) != null) {
                return this.greenColorStyler;
            }
            return null;
        }

        private StyledString.Styler getFontStyler(Object object) {
            if (MoveStagingView.this.stage.getElements().contains(object)) {
                if (this.boldFontStyler == null) {
                    FontDescriptor descriptor = FontDescriptor.createFrom((Font)JFaceResources.getDefaultFont()).setStyle(1);
                    this.boldFont = descriptor.createFont(JFaceResources.getDefaultFont().getDevice());
                    this.boldFontStyler = new StyledString.Styler(){

                        public void applyStyles(TextStyle textStyle) {
                            textStyle.font = StageLabelDecorator.this.boldFont;
                        }
                    };
                }
                return this.boldFontStyler;
            }
            if (object instanceof EObject && EcoreUtil.isAncestor((Collection)MoveStagingView.this.stage.getElements(), (EObject)((EObject)object))) {
                return null;
            }
            if (this.italicFontStyler == null) {
                FontDescriptor descriptor = FontDescriptor.createFrom((Font)JFaceResources.getDefaultFont()).setStyle(2);
                this.italicFont = descriptor.createFont(JFaceResources.getDefaultFont().getDevice());
                this.italicFontStyler = new StyledString.Styler(){

                    public void applyStyles(TextStyle textStyle) {
                        textStyle.font = StageLabelDecorator.this.italicFont;
                        textStyle.foreground = Display.getCurrent().getSystemColor(16);
                    }
                };
            }
            return this.italicFontStyler;
        }

        public void update(ViewerCell cell) {
        }

        public void dispose() {
            if (this.boldFont != null) {
                this.boldFont.dispose();
            }
            if (this.italicFont != null) {
                this.italicFont.dispose();
            }
        }
    }

    private abstract class TreeViewerAction
    extends Action {
        private final TreeViewer viewer;

        private TreeViewerAction(TreeViewer viewer) {
            this.viewer = viewer;
        }

        protected TreeViewer getViewer() {
            return this.viewer;
        }
    }

    private class UnstageAction
    extends AbstractDeleteAction {
        private UnstageAction() {
            super(Messages.MoveStagingView_unstageLabel);
            this.setToolTipText(Messages.MoveStagingView_unstageLabel);
        }

        public void run() {
            ArrayList<EObject> toRemove = new ArrayList<EObject>();
            TreeIterator it = EcoreUtil.getAllContents((Collection)this.getStructuredSelection().toList());
            while (it.hasNext()) {
                EObject next = (EObject)it.next();
                if (!MoveStagingView.this.stage.getElements().contains(next)) continue;
                toRemove.add(next);
            }
            MoveStagingView.this.stage.removeAll(toRemove);
        }
    }
}

